/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWritablePropertyValueModel<T>
extends PropertyValueModelWrapper<T>
implements WritablePropertyValueModel<T> {
    protected T bufferedValue;
    protected boolean accepting;
    protected final PropertyValueModel<Boolean> triggerHolder;
    protected final PropertyChangeListener triggerChangeListener;
    protected boolean buffering;

    public BufferedWritablePropertyValueModel(WritablePropertyValueModel<T> valueHolder, PropertyValueModel<Boolean> triggerHolder) {
        super(valueHolder);
        if (triggerHolder == null) {
            throw new NullPointerException();
        }
        this.triggerHolder = triggerHolder;
        this.bufferedValue = null;
        this.buffering = false;
        this.accepting = false;
        this.triggerChangeListener = this.buildTriggerChangeListener();
    }

    protected PropertyChangeListener buildTriggerChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                BufferedWritablePropertyValueModel.this.triggerChanged(event);
            }

            public String toString() {
                return "trigger change listener";
            }
        };
    }

    @Override
    public T getValue() {
        return this.buffering ? this.bufferedValue : this.valueHolder.getValue();
    }

    @Override
    public void setValue(T value) {
        T old = this.getValue();
        this.bufferedValue = value;
        this.buffering = true;
        this.firePropertyChanged("value", old, this.bufferedValue);
    }

    @Override
    protected void engageValueHolder() {
        super.engageValueHolder();
        this.triggerHolder.addPropertyChangeListener("value", this.triggerChangeListener);
    }

    @Override
    protected void disengageValueHolder() {
        this.triggerHolder.removePropertyChangeListener("value", this.triggerChangeListener);
        super.disengageValueHolder();
    }

    @Override
    protected void valueChanged(PropertyChangeEvent event) {
        if (this.accepting) {
            return;
        }
        if (this.buffering) {
            this.handleChangeConflict(event);
        } else {
            this.firePropertyChanged(event.cloneWithSource(this));
        }
    }

    protected void handleChangeConflict(PropertyChangeEvent event) {
    }

    protected void triggerChanged(PropertyChangeEvent event) {
        if (!this.buffering) {
            return;
        }
        if (((Boolean)event.getNewValue()).booleanValue()) {
            this.accepting = true;
            this.valueHolder().setValue(this.bufferedValue);
            this.bufferedValue = null;
            this.buffering = false;
            this.accepting = false;
        } else {
            T old = this.bufferedValue;
            this.bufferedValue = null;
            this.buffering = false;
            this.firePropertyChanged("value", old, this.valueHolder.getValue());
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    protected WritablePropertyValueModel<T> valueHolder() {
        return (WritablePropertyValueModel)this.valueHolder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Trigger
    extends SimplePropertyValueModel<Boolean> {
        @Override
        public Boolean getValue() {
            if (this.value == null) {
                throw new IllegalStateException("The method Trigger.value() may only be called during change notification.");
            }
            return (Boolean)this.value;
        }

        @Override
        public void setValue(Boolean value) {
            super.setValue(value);
            this.value = null;
        }

        @Override
        public void setValue(boolean value) {
            this.setValue((Boolean)value);
        }

        public boolean booleanValue() {
            return this.getValue();
        }

        public void accept() {
            this.setValue(true);
        }

        public boolean isAccepted() {
            return this.booleanValue();
        }

        public void reset() {
            this.setValue(false);
        }

        public boolean isReset() {
            return !this.booleanValue();
        }
    }
}

