/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.ColumnCombo;
import org.eclipse.jpt.ui.internal.mappings.db.DatabaseObjectCombo;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnComposite
extends FormPane<Column> {
    public ColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public ColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent, boolean automaticallyAlignWidgets) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets);
    }

    public ColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent, boolean automaticallyAlignWidgets, boolean parentManagePane) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets, parentManagePane);
    }

    private ColumnCombo<Column> addColumnCombo(Composite container) {
        return new ColumnCombo<Column>((Pane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                if (propertyName == "defaultTable" || propertyName == "specifiedTable") {
                    this.doPopulate();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            @Override
            protected String getDefaultValue() {
                return ((Column)this.getSubject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((Column)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((Column)this.getSubject()).getDbTable();
            }

            @Override
            protected String getValue() {
                return ((Column)this.getSubject()).getSpecifiedName();
            }

            public String toString() {
                return "ColumnComposite.columnCombo";
            }
        };
    }

    private WritablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<Column, String>(this.getSubjectHolder(), new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((Column)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Column)this.subject).setColumnDefinition(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultLengthHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultLength"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getDefaultLength();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control addDefaultLengthLabel(Composite container) {
        Label label = this.addLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultLengthLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultLengthLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultLengthHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = ColumnComposite.this.getSubject() != null ? ((Column)ColumnComposite.this.getSubject()).getDefaultLength() : Column.DEFAULT_LENGTH;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultPrecisionHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultPrecision"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getDefaultPrecision();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control addDefaultPrecisionLabel(Composite container) {
        Label label = this.addLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultPrecisionLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultPrecisionLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultPrecisionHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = ColumnComposite.this.getSubject() != null ? ((Column)ColumnComposite.this.getSubject()).getDefaultPrecision() : Column.DEFAULT_PRECISION;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultScaleHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultScale"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getDefaultScale();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private Control addDefaultScaleLabel(Composite container) {
        Label label = this.addLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultScaleLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultScaleLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultScaleHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = ColumnComposite.this.getSubject() != null ? ((Column)ColumnComposite.this.getSubject()).getDefaultScale() : Column.DEFAULT_SCALE;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildInsertableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedInsertable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedInsertable(value);
            }
        };
    }

    private PropertyValueModel<String> buildInsertableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildInsertableHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.getSubject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.getSubject()).getDefaultInsertable()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_insertableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_insertable;
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildLengthHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"spcifiedLength"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getSpecifiedLength();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((Column)this.subject).setSpecifiedLength(value);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNullableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultNullable", "specifiedNullable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedNullable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedNullable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildNullableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildNullableHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.getSubject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.getSubject()).getDefaultNullable()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_nullableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_nullable;
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildPrecisionHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"spcifiedPrecision"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getSpecifiedPrecision();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((Column)this.subject).setSpecifiedPrecision(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildScaleHolder() {
        return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"spcifiedScale"}){

            protected Integer buildValue_() {
                return ((Column)this.subject).getSpecifiedScale();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((Column)this.subject).setSpecifiedScale(value);
            }
        };
    }

    private Pane<Column> addTableCombo(Composite container) {
        return new DatabaseObjectCombo<Column>((Pane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            @Override
            protected String getDefaultValue() {
                return ((Column)this.getSubject()).getDefaultTable();
            }

            @Override
            protected void setValue(String value) {
                ((Column)this.getSubject()).setSpecifiedTable(value);
            }

            @Override
            protected String getValue() {
                return ((Column)this.getSubject()).getSpecifiedTable();
            }

            @Override
            protected Iterator<String> values() {
                return ((Column)this.getSubject()).getOwner().getTypeMapping().associatedTableNamesIncludingInherited();
            }

            public String toString() {
                return "ColumnComposite.tableCombo";
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUniqueHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultUnique", "specifiedUnique"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUnique();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUnique(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUniqueStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUniqueHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.getSubject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.getSubject()).getDefaultUnique()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_uniqueWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_unique;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUpdatableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaulUpdatable", "specifiedUpdatable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUpdatable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUpdatable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUpdatableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUpdatableHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (ColumnComposite.this.getSubject() != null && value == null && (defaultValue = ((Column)ColumnComposite.this.getSubject()).getDefaultUpdatable()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_updatableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_updatable;
            }
        };
    }

    private void initializeDetailsPane(Composite container) {
        this.addTriStateCheckBoxWithDefault(this.addSubPane(container, 4), JptUiMappingsMessages.ColumnComposite_insertable, this.buildInsertableHolder(), this.buildInsertableStringHolder(), "org.eclipse.jpt.ui.mapping_columnInsertable");
        this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_updatable, this.buildUpdatableHolder(), this.buildUpdatableStringHolder(), "org.eclipse.jpt.ui.mapping_columnUpdatable");
        this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_unique, this.buildUniqueHolder(), this.buildUniqueStringHolder(), "org.eclipse.jpt.ui.mapping_columnUnique");
        this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_nullable, this.buildNullableHolder(), this.buildNullableStringHolder(), "org.eclipse.jpt.ui.mapping_columnNullable");
        Spinner lengthSpinner = this.addLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_length, this.buildLengthHolder(), -1, -1, Integer.MAX_VALUE, this.addDefaultLengthLabel(container), "org.eclipse.jpt.ui.mapping_columnLength");
        this.updateGridData(container, lengthSpinner);
        Spinner precisionSpinner = this.addLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_precision, this.buildPrecisionHolder(), -1, -1, Integer.MAX_VALUE, this.addDefaultPrecisionLabel(container), "org.eclipse.jpt.ui.mapping_columnPrecision");
        this.updateGridData(container, precisionSpinner);
        Spinner scaleSpinner = this.addLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_scale, this.buildScaleHolder(), -1, -1, Integer.MAX_VALUE, this.addDefaultScaleLabel(container), "org.eclipse.jpt.ui.mapping_columnScale");
        this.updateGridData(container, scaleSpinner);
        this.addLabeledText(container, JptUiMappingsMessages.ColumnComposite_columnDefinition, this.buildColumnDefinitionHolder());
    }

    @Override
    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, JptUiMappingsMessages.ColumnComposite_columnSection);
        this.addLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_name, this.addColumnCombo(container), "org.eclipse.jpt.ui.mapping_column");
        this.addLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_table, this.addTableCombo(container), "org.eclipse.jpt.ui.mapping_columnTable");
        container = this.addCollapsableSubSection(container, JptUiMappingsMessages.ColumnComposite_details, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
        this.initializeDetailsPane(this.addSubPane(container, 0, 16));
    }

    private void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

