/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.navigator.JpaNavigatorContentAndLabelProvider;
import org.eclipse.jpt.ui.internal.navigator.JpaNavigatorLabelProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class JpaNavigatorContentProvider
implements ICommonContentProvider {
    private JpaNavigatorContentAndLabelProvider delegate;
    private IFacetedProjectListener facetListener = new FacetListener();
    private StructuredViewer viewer;

    public JpaNavigatorContentProvider() {
        FacetedProjectFramework.addListener((IFacetedProjectListener)this.facetListener, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.POST_INSTALL, IFacetedProjectEvent.Type.POST_UNINSTALL, IFacetedProjectEvent.Type.PROJECT_MODIFIED});
    }

    public JpaNavigatorContentAndLabelProvider delegate() {
        return this.delegate;
    }

    public void dispose() {
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this.facetListener);
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.delegate != null) {
            this.delegate.inputChanged(viewer, oldInput, newInput);
        }
        this.viewer = (StructuredViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (this.delegate != null) {
            return this.delegate.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        JpaProject jpaProject;
        IProject project;
        if (element instanceof IAdaptable && (project = (IProject)((IAdaptable)element).getAdapter(IProject.class)) != null && (jpaProject = JptCorePlugin.getJpaProject((IProject)project)) != null) {
            JpaPlatformUi platformUi = JptUiPlugin.getPlugin().jpaPlatformUi(jpaProject.getJpaPlatform());
            return platformUi != null;
        }
        if (this.delegate != null) {
            return this.delegate.hasChildren(element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        JpaPlatformUi platformUi;
        JpaProject jpaProject;
        IProject project;
        if (parentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)parentElement).getAdapter(IProject.class)) != null && (jpaProject = JptCorePlugin.getJpaProject((IProject)project)) != null && (platformUi = JptUiPlugin.getPlugin().jpaPlatformUi(jpaProject.getJpaPlatform())) != null) {
            return new Object[]{jpaProject.getRootContextNode()};
        }
        if (this.delegate != null) {
            return this.delegate.getChildren(parentElement);
        }
        return new Object[0];
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void init(ICommonContentExtensionSite config) {
        if (this.delegate == null) {
            JpaNavigatorLabelProvider labelProvider = (JpaNavigatorLabelProvider)config.getExtension().getLabelProvider();
            this.delegate = labelProvider != null && labelProvider.delegate() != null ? labelProvider.delegate() : new JpaNavigatorContentAndLabelProvider();
        }
    }

    private class FacetListener
    implements IFacetedProjectListener {
        private FacetListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            IProjectFacetActionEvent ipaEvent;
            if (event.getType() == IFacetedProjectEvent.Type.PROJECT_MODIFIED) {
                this.refreshViewer(event.getProject().getProject());
            } else if ((event.getType() == IFacetedProjectEvent.Type.POST_INSTALL || event.getType() == IFacetedProjectEvent.Type.POST_UNINSTALL) && (ipaEvent = (IProjectFacetActionEvent)event).getProjectFacet().equals(ProjectFacetsManager.getProjectFacet((String)"jpt.jpa"))) {
                this.refreshViewer(ipaEvent.getProject().getProject());
            }
        }

        private void refreshViewer(final IProject project) {
            if (JpaNavigatorContentProvider.this.viewer != null && JpaNavigatorContentProvider.this.viewer.getControl() != null && !JpaNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                Job refreshJob = new Job("Refresh viewer"){

                    protected IStatus run(IProgressMonitor monitor) {
                        JpaNavigatorContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                JpaNavigatorContentProvider.this.viewer.refresh((Object)project);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setRule((ISchedulingRule)project);
                refreshJob.schedule();
            }
        }
    }
}

