/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.PrivateOwned;
import org.eclipse.jpt.eclipselink.core.resource.java.PrivateOwnedAnnotation;

public class EclipseLinkJavaPrivateOwned
extends AbstractJavaJpaContextNode
implements PrivateOwned {
    protected boolean privateOwned;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    public EclipseLinkJavaPrivateOwned(JavaAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    protected String getPrivateOwnedAnnotationName() {
        return "org.eclipse.persistence.annotations.PrivateOwned";
    }

    protected PrivateOwnedAnnotation getResourcePrivateOwned() {
        return (PrivateOwnedAnnotation)this.resourcePersistentAttribute.getSupportingAnnotation(this.getPrivateOwnedAnnotationName());
    }

    protected void addResourcePrivateOwned() {
        this.resourcePersistentAttribute.addSupportingAnnotation(this.getPrivateOwnedAnnotationName());
    }

    protected void removeResourcePrivateOwned() {
        this.resourcePersistentAttribute.removeSupportingAnnotation(this.getPrivateOwnedAnnotationName());
    }

    public boolean isPrivateOwned() {
        return this.privateOwned;
    }

    public void setPrivateOwned(boolean newPrivateOwned) {
        if (this.privateOwned == newPrivateOwned) {
            return;
        }
        boolean oldPrivateOwned = this.privateOwned;
        this.privateOwned = newPrivateOwned;
        if (newPrivateOwned) {
            this.addResourcePrivateOwned();
        } else if (this.getResourcePrivateOwned() != null) {
            this.removeResourcePrivateOwned();
        }
        this.firePropertyChanged("privateOwnedProperty", oldPrivateOwned, newPrivateOwned);
    }

    protected void setPrivateOwned_(boolean newPrivateOwned) {
        boolean oldPrivateOwned = this.privateOwned;
        this.privateOwned = newPrivateOwned;
        this.firePropertyChanged("privateOwnedProperty", oldPrivateOwned, newPrivateOwned);
    }

    public void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.privateOwned = this.privateOwned();
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.setPrivateOwned_(this.privateOwned());
    }

    private boolean privateOwned() {
        return this.getResourcePrivateOwned() != null;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        PrivateOwnedAnnotation resourcePrivateOwned = this.getResourcePrivateOwned();
        return resourcePrivateOwned == null ? null : resourcePrivateOwned.getTextRange(astRoot);
    }
}

