/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkImpliedMappingFileRef;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.EclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.Connection;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.EclipseLinkConnection;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.EclipseLinkCustomization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.EclipseLinkGeneralProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.GeneralProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.EclipseLinkLogging;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.Logging;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.EclipseLinkOptions;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.SchemaGeneration;
import org.eclipse.jpt.eclipselink.core.internal.resource.orm.EclipseLinkOrmResourceModelProvider;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmResource;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkPersistenceUnit
extends AbstractPersistenceUnit {
    protected MappingFileRef impliedEclipseLinkMappingFileRef;
    private GeneralProperties generalProperties;
    private Connection connection;
    private Customization customization;
    private Caching caching;
    private Logging logging;
    private Options options;
    private SchemaGeneration schemaGeneration;
    private final ListValueModel<Property> propertiesAdapter;
    private final ListValueModel<Property> propertyListAdapter;
    protected final List<EclipseLinkConverter> converters = new ArrayList<EclipseLinkConverter>();
    public static final String IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY = "impliedEclipseLinkMappingFileRef";
    public static final String CONVERTERS_LIST = "converters";

    public EclipseLinkPersistenceUnit(Persistence parent, XmlPersistenceUnit persistenceUnit) {
        super(parent);
        this.propertiesAdapter = this.buildPropertiesAdapter();
        this.propertyListAdapter = this.buildPropertyListAdapter(this.propertiesAdapter);
        this.initialize(persistenceUnit);
    }

    protected void initializeProperties(XmlPersistenceUnit xpu) {
        super.initializeProperties(xpu);
        this.generalProperties = new EclipseLinkGeneralProperties((PersistenceUnit)this, this.propertyListAdapter);
        this.connection = new EclipseLinkConnection((PersistenceUnit)this, this.propertyListAdapter);
        this.customization = new EclipseLinkCustomization((PersistenceUnit)this, this.propertyListAdapter);
        this.caching = new EclipseLinkCaching((PersistenceUnit)this, this.propertyListAdapter);
        this.logging = new EclipseLinkLogging((PersistenceUnit)this, this.propertyListAdapter);
        this.options = new EclipseLinkOptions((PersistenceUnit)this, this.propertyListAdapter);
        this.schemaGeneration = new EclipseLinkSchemaGeneration((PersistenceUnit)this, this.propertyListAdapter);
    }

    private ListValueModel<Property> buildPropertyListAdapter(ListValueModel<Property> propertiesAdapter) {
        return new ItemPropertyListValueModelAdapter(propertiesAdapter, new String[]{"value"});
    }

    private ListValueModel<Property> buildPropertiesAdapter() {
        return new ListAspectAdapter<PersistenceUnit, Property>((PropertyValueModel)new SimplePropertyValueModel((Object)this), new String[]{"properties"}){

            protected ListIterator<Property> listIterator_() {
                return ((PersistenceUnit)this.subject).properties();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).propertiesSize();
            }
        };
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add(CONVERTERS_LIST);
    }

    public ListIterator<MappingFileRef> mappingFileRefs() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            return super.mappingFileRefs();
        }
        return new ReadOnlyCompositeListIterator(super.mappingFileRefs(), (Object)this.impliedEclipseLinkMappingFileRef);
    }

    public int mappingFileRefsSize() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            return super.mappingFileRefsSize();
        }
        return 1 + super.mappingFileRefsSize();
    }

    public MappingFileRef getImpliedEclipseLinkMappingFileRef() {
        return this.impliedEclipseLinkMappingFileRef;
    }

    protected MappingFileRef setImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef != null) {
            throw new IllegalStateException("The implied eclipselink mapping file ref is already set.");
        }
        EclipseLinkImpliedMappingFileRef mappingFileRef = new EclipseLinkImpliedMappingFileRef((PersistenceUnit)this);
        this.impliedEclipseLinkMappingFileRef = mappingFileRef;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, null, (Object)mappingFileRef);
        return mappingFileRef;
    }

    protected void unsetImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            throw new IllegalStateException("The implied eclipselink mapping file ref is already unset.");
        }
        MappingFileRef mappingFileRef = this.impliedEclipseLinkMappingFileRef;
        this.impliedEclipseLinkMappingFileRef.dispose();
        this.impliedEclipseLinkMappingFileRef = null;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, mappingFileRef, null);
    }

    public GeneralProperties getGeneralProperties() {
        return this.generalProperties;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Customization getCustomization() {
        return this.customization;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Options getOptions() {
        return this.options;
    }

    public SchemaGeneration getSchemaGeneration() {
        return this.schemaGeneration;
    }

    public ListValueModel<Property> getPropertiesAdapter() {
        return this.propertiesAdapter;
    }

    public ListValueModel<Property> getPropertyListAdapter() {
        return this.propertyListAdapter;
    }

    public void addConverter(EclipseLinkConverter converter) {
        this.converters.add(converter);
    }

    public ListIterator<EclipseLinkConverter> allConverters() {
        return new CloneListIterator(this.converters);
    }

    public String[] uniqueConverterNames() {
        HashSet names = CollectionTools.set(this.allNonNullConverterNames());
        return names.toArray(new String[names.size()]);
    }

    protected Iterator<String> allNonNullConverterNames() {
        return new FilteringIterator<String, String>(this.allConverterNames()){

            protected boolean accept(String converterName) {
                return converterName != null;
            }
        };
    }

    protected Iterator<String> allConverterNames() {
        return new TransformationIterator<EclipseLinkConverter, String>(this.allConverters()){

            protected String transform(EclipseLinkConverter converter) {
                return converter.getName();
            }
        };
    }

    public void update(XmlPersistenceUnit persistenceUnit) {
        this.converters.clear();
        super.update(persistenceUnit);
        this.convertersUpdated();
    }

    protected void initializeMappingFileRefs(XmlPersistenceUnit xpu) {
        super.initializeMappingFileRefs(xpu);
        if (!this.impliedEclipseLinkMappingFileIsExcluded() && !this.impliedEclipseLinkMappingFileIsSpecified() && this.impliedEclipseLinkMappingFileExists()) {
            this.impliedEclipseLinkMappingFileRef = new EclipseLinkImpliedMappingFileRef((PersistenceUnit)this);
        }
    }

    protected void updateMappingFileRefs(XmlPersistenceUnit persistenceUnit) {
        super.updateMappingFileRefs(persistenceUnit);
        if (!this.impliedEclipseLinkMappingFileIsExcluded() && !this.impliedEclipseLinkMappingFileIsSpecified() && this.impliedEclipseLinkMappingFileExists()) {
            if (this.impliedEclipseLinkMappingFileRef == null) {
                this.setImpliedEclipseLinkMappingFileRef();
            }
            this.getImpliedEclipseLinkMappingFileRef().update(null);
        } else if (this.impliedEclipseLinkMappingFileRef != null) {
            this.unsetImpliedEclipseLinkMappingFileRef();
        }
    }

    protected boolean impliedEclipseLinkMappingFileIsExcluded() {
        return this.getGeneralProperties().getExcludeEclipselinkOrm() == Boolean.TRUE;
    }

    protected boolean impliedEclipseLinkMappingFileIsSpecified() {
        String impliedMappingFile = "META-INF/eclipselink-orm.xml";
        ListIterator stream = this.specifiedMappingFileRefs();
        while (stream.hasNext()) {
            if (!impliedMappingFile.equals(((MappingFileRef)stream.next()).getFileName())) continue;
            return true;
        }
        return false;
    }

    protected boolean impliedEclipseLinkMappingFileExists() {
        EclipseLinkOrmResourceModelProvider modelProvider = EclipseLinkOrmResourceModelProvider.getDefaultModelProvider(this.getJpaProject().getProject());
        EclipseLinkOrmResource resource = (EclipseLinkOrmResource)modelProvider.getResource();
        return resource != null && resource.exists();
    }

    protected void convertersUpdated() {
        this.fireListChanged(CONVERTERS_LIST);
    }
}

