/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.resource.java.CustomizerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizerImpl
extends AbstractResourceAnnotation<Type>
implements CustomizerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Customizer");
    private final AnnotationElementAdapter<String> valueAdapter;
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = CustomizerImpl.buildValueAdapter();
    private String value;
    private boolean implementsDescriptorCustomizer;

    protected CustomizerImpl(JavaResourcePersistentMember parent, Type type) {
        super((JavaResourceNode)parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, VALUE_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
        this.implementsDescriptorCustomizer = this.implementsDescriptorCustomizer(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Customizer";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.attributeValueHasNotChanged(this.value, newValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue((Object)newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    @Override
    public boolean implementsDescriptorCustomizer() {
        return this.implementsDescriptorCustomizer;
    }

    protected void setImplementsDescriptorCustomizer(boolean newImplementsDescriptorCustomizer) {
        boolean oldImplementsDescriptorCustomizer = this.implementsDescriptorCustomizer;
        this.implementsDescriptorCustomizer = newImplementsDescriptorCustomizer;
        this.firePropertyChanged("implementsDescriptorCustomizerProperty", oldImplementsDescriptorCustomizer, newImplementsDescriptorCustomizer);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
        this.setImplementsDescriptorCustomizer(this.implementsDescriptorCustomizer(astRoot));
    }

    protected String value(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    private boolean implementsDescriptorCustomizer(CompilationUnit astRoot) {
        if (this.value == null) {
            return false;
        }
        return JDTTools.findTypeInHierarchy((Expression)this.valueAdapter.getExpression(astRoot), (String)"org.eclipse.persistence.config.DescriptorCustomizer") != null;
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false, SimpleTypeStringExpressionConverter.instance());
    }

    public static class CustomizerAnnotationDefinition
    implements AnnotationDefinition {
        private static final CustomizerAnnotationDefinition INSTANCE = new CustomizerAnnotationDefinition();

        public static CustomizerAnnotationDefinition instance() {
            return INSTANCE;
        }

        private CustomizerAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new CustomizerImpl(parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Customizer";
        }
    }
}

