/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.GenericJavaNullConverter;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaBasicMapping
extends AbstractJavaAttributeMapping<BasicAnnotation>
implements JavaBasicMapping {
    protected FetchType specifiedFetch;
    protected Boolean specifiedOptional;
    protected final JavaColumn column = this.createJavaColumn();
    protected final JavaConverter defaultConverter = new GenericJavaNullConverter(this);
    protected JavaConverter specifiedConverter;

    public GenericJavaBasicMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaColumn createJavaColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    public void initialize(JavaResourcePersistentAttribute jrpa) {
        super.initialize(jrpa);
        this.column.initialize(this.getResourceColumn());
        this.specifiedConverter = this.buildSpecifiedConverter(this.specifiedConverterType(jrpa));
    }

    @Override
    protected void initialize(BasicAnnotation basicResource) {
        this.specifiedFetch = this.specifiedFetchType(basicResource);
        this.specifiedOptional = this.specifiedOptional(basicResource);
    }

    @Override
    public ColumnAnnotation getResourceColumn() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullSupportingAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Basic";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.Lob", "javax.persistence.Temporal", "javax.persistence.Enumerated"});
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return BasicMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((BasicAnnotation)this.getResourceMapping()).setFetch(FetchType.toJavaResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public Boolean getOptional() {
        return this.getSpecifiedOptional() == null ? this.getDefaultOptional() : this.getSpecifiedOptional();
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        ((BasicAnnotation)this.getResourceMapping()).setOptional(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    @Override
    public JavaConverter getConverter() {
        return this.getSpecifiedConverter() == null ? this.getDefaultConverter() : this.getSpecifiedConverter();
    }

    @Override
    public JavaConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    public JavaConverter getSpecifiedConverter() {
        return this.specifiedConverter;
    }

    protected String getSpecifedConverterType() {
        if (this.specifiedConverter == null) {
            return "noConverter";
        }
        return this.specifiedConverter.getType();
    }

    @Override
    public void setSpecifiedConverter(String converterType) {
        if (this.getSpecifedConverterType() == converterType) {
            return;
        }
        JavaConverter oldConverter = this.specifiedConverter;
        JavaConverter newConverter = this.buildSpecifiedConverter(converterType);
        this.specifiedConverter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.specifiedConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    protected void setSpecifiedConverter(JavaConverter newConverter) {
        JavaConverter oldConverter = this.specifiedConverter;
        this.specifiedConverter = newConverter;
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    @Override
    public void update(JavaResourcePersistentAttribute jrpa) {
        super.update(jrpa);
        this.column.update(this.getResourceColumn());
        if (this.specifiedConverterType(jrpa) == this.getSpecifedConverterType()) {
            this.getSpecifiedConverter().update(jrpa);
        } else {
            JavaConverter javaConverter = this.buildSpecifiedConverter(this.specifiedConverterType(jrpa));
            this.setSpecifiedConverter(javaConverter);
        }
    }

    @Override
    protected void update(BasicAnnotation basicResource) {
        this.setSpecifiedFetch_(this.specifiedFetchType(basicResource));
        this.setSpecifiedOptional_(this.specifiedOptional(basicResource));
    }

    protected FetchType specifiedFetchType(BasicAnnotation basic) {
        return FetchType.fromJavaResourceModel(basic.getFetch());
    }

    protected Boolean specifiedOptional(BasicAnnotation basic) {
        return basic.getOptional();
    }

    protected JavaConverter buildSpecifiedConverter(String converterType) {
        if (converterType == "enumeratedConverter") {
            return this.getJpaFactory().buildJavaEnumeratedConverter(this, this.resourcePersistentAttribute);
        }
        if (converterType == "temporalConverter") {
            return this.getJpaFactory().buildJavaTemporalConverter(this, this.resourcePersistentAttribute);
        }
        if (converterType == "lobConverter") {
            return this.getJpaFactory().buildJavaLobConverter(this, this.resourcePersistentAttribute);
        }
        return null;
    }

    protected String specifiedConverterType(JavaResourcePersistentAttribute jrpa) {
        if (jrpa.getSupportingAnnotation("javax.persistence.Enumerated") != null) {
            return "enumeratedConverter";
        }
        if (jrpa.getSupportingAnnotation("javax.persistence.Temporal") != null) {
            return "temporalConverter";
        }
        if (jrpa.getSupportingAnnotation("javax.persistence.Lob") != null) {
            return "lobConverter";
        }
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        if (this.ownerIsEntity() && this.connectionProfileIsActive()) {
            this.validateColumn(messages, astRoot);
        }
        if (this.specifiedConverter != null) {
            this.specifiedConverter.validate(messages, astRoot);
        }
    }

    protected void validateColumn(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTypeMapping().tableNameIsInvalid(this.column.getTable())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{this.column.getTable(), this.column.getName()}, this.column, this.column.getTableTextRange(astRoot)));
            return;
        }
        if (!this.column.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange(astRoot)));
        }
    }
}

