/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.MultiRelationshipMapping;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.MapKey;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlMultiRelationshipMapping;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmMultiRelationshipMapping<T extends XmlMultiRelationshipMapping>
extends AbstractOrmRelationshipMapping<T>
implements OrmMultiRelationshipMapping {
    protected String mappedBy;
    protected String orderBy;
    protected boolean isNoOrdering;
    protected boolean isPkOrdering;
    protected boolean isCustomOrdering;
    protected final OrmJoinTable joinTable = this.getJpaFactory().buildOrmJoinTable(this);
    protected String mapKey;

    protected AbstractOrmMultiRelationshipMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initializeFromOrmMulitRelationshipMapping(OrmMultiRelationshipMapping oldMapping) {
        super.initializeFromOrmMulitRelationshipMapping(oldMapping);
        this.getJoinTable().initializeFrom(oldMapping.getJoinTable());
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public FetchType getDefaultFetch() {
        return MultiRelationshipMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setMappedBy(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    protected void setMappedBy_(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setOrderBy(newOrderBy);
        this.firePropertyChanged("orderBy", oldOrderBy, newOrderBy);
    }

    protected void setOrderBy_(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        this.firePropertyChanged("orderBy", oldOrderBy, newOrderBy);
    }

    @Override
    public boolean isNoOrdering() {
        return this.isNoOrdering;
    }

    @Override
    public void setNoOrdering(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        if (newNoOrdering) {
            ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setOrderBy(null);
        }
        this.firePropertyChanged("noOrdering", oldNoOrdering, newNoOrdering);
    }

    protected void setNoOrdering_(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        this.firePropertyChanged("noOrdering", oldNoOrdering, newNoOrdering);
    }

    @Override
    public boolean isPkOrdering() {
        return this.isPkOrdering;
    }

    @Override
    public void setPkOrdering(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        if (newPkOrdering) {
            ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setOrderBy("");
        }
        this.firePropertyChanged("pkOrdering", oldPkOrdering, newPkOrdering);
    }

    protected void setPkOrdering_(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        this.firePropertyChanged("pkOrdering", oldPkOrdering, newPkOrdering);
    }

    @Override
    public boolean isCustomOrdering() {
        return this.isCustomOrdering;
    }

    @Override
    public void setCustomOrdering(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        if (newCustomOrdering) {
            this.setOrderBy("");
        }
        this.firePropertyChanged("customOrdering", oldCustomOrdering, newCustomOrdering);
    }

    protected void setCustomOrdering_(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        this.firePropertyChanged("customOrdering", oldCustomOrdering, newCustomOrdering);
    }

    @Override
    public OrmJoinTable getJoinTable() {
        return this.joinTable;
    }

    @Override
    public boolean joinTableIsSpecified() {
        return this.getJoinTable().isSpecified();
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public void setMapKey(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        if (oldMapKey != newMapKey) {
            if (this.getResourceMapKey() != null) {
                this.getResourceMapKey().setName(newMapKey);
                if (this.getResourceMapKey().isAllFeaturesUnset()) {
                    this.removeResourceMapKey();
                }
            } else if (newMapKey != null) {
                this.addResourceMapKey();
                this.getResourceMapKey().setName(newMapKey);
            }
        }
        this.firePropertyChanged("mapKey", oldMapKey, newMapKey);
    }

    protected void setMapKey_(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        this.firePropertyChanged("mapKey", oldMapKey, newMapKey);
    }

    protected MapKey getResourceMapKey() {
        return ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMapKey();
    }

    protected void removeResourceMapKey() {
        ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setMapKey(null);
    }

    protected void addResourceMapKey() {
        ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setMapKey(OrmFactory.eINSTANCE.createMapKeyImpl());
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEntityAttributeNames();
    }

    public TextRange getMappedByTextRange() {
        TextRange mappedByTextRange = ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMappedByTextRange();
        return mappedByTextRange != null ? mappedByTextRange : this.getValidationTextRange();
    }

    @Override
    public void initialize(XmlAttributeMapping attributeMapping) {
        super.initialize(attributeMapping);
        this.mappedBy = ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMappedBy();
        this.mapKey = this.mapKey();
        this.orderBy = this.orderBy();
        if (this.orderBy == null) {
            this.isNoOrdering = true;
        } else {
            this.isCustomOrdering = true;
        }
        this.joinTable.initialize((XmlRelationshipMapping)this.resourceAttributeMapping);
    }

    @Override
    public void update() {
        super.update();
        this.setMappedBy_(((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMappedBy());
        this.setMapKey_(this.mapKey());
        this.setOrderBy_(this.orderBy());
        if (this.getOrderBy() == null) {
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
        } else {
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(true);
        }
        this.joinTable.update();
    }

    protected String mapKey() {
        return ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMapKey() == null ? null : ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMapKey().getName();
    }

    protected String orderBy() {
        return ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getOrderBy();
    }

    @Override
    protected String defaultTargetEntity(JavaResourcePersistentAttribute jrpa) {
        if (!jrpa.typeIsContainer()) {
            return null;
        }
        return jrpa.getQualifiedReferenceEntityElementTypeName();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.ownerIsEntity() && (this.joinTableIsSpecified() || this.isRelationshipOwner())) {
            this.joinTable.validate(messages);
        }
        if (this.mappedBy != null) {
            this.validateMappedBy(messages);
        }
    }

    protected void validateMappedBy(List<IMessage> messages) {
        Entity targetEntity;
        if (this.joinTableIsSpecified()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_WITH_JOIN_TABLE", this.joinTable, this.joinTable.getValidationTextRange()));
        }
        if ((targetEntity = this.getResolvedTargetEntity()) == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(this.mappedBy);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.mappedBy}, this, this.getMappedByTextRange()));
            return;
        }
        AttributeMapping mappedByMapping = attribute.getMapping();
        if (!this.mappedByIsValid(mappedByMapping)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{this.mappedBy}, this, this.getMappedByTextRange()));
            return;
        }
        if (mappedByMapping instanceof NonOwningMapping && ((NonOwningMapping)mappedByMapping).getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange()));
        }
    }
}

