/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryHint;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlQuery;
import org.eclipse.jpt.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmQuery<E extends XmlQuery>
extends AbstractXmlContextNode
implements OrmQuery {
    protected String name;
    protected String query;
    protected final List<OrmQueryHint> hints = new ArrayList<OrmQueryHint>();
    protected E resourceQuery;

    protected AbstractOrmQuery(XmlContextNode parent, E resourceQuery) {
        super(parent);
        this.initialize(resourceQuery);
    }

    protected E getResourceQuery() {
        return this.resourceQuery;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getResourceQuery().setName(newName);
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        this.getResourceQuery().setQuery(newQuery);
        this.firePropertyChanged("query", oldQuery, newQuery);
    }

    @Override
    public ListIterator<OrmQueryHint> hints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public OrmQueryHint addHint(int index) {
        XmlQueryHint resourceQueryHint = OrmFactory.eINSTANCE.createXmlQueryHint();
        OrmQueryHint contextQueryHint = this.buildQueryHint(resourceQueryHint);
        this.hints.add(index, contextQueryHint);
        this.getResourceQuery().getHints().add(index, (Object)resourceQueryHint);
        this.fireItemAdded("hints", index, contextQueryHint);
        return contextQueryHint;
    }

    protected void addHint(int index, OrmQueryHint queryHint) {
        this.addItemToList(index, queryHint, this.hints, "hints");
    }

    protected void addHint(OrmQueryHint queryHint) {
        this.addHint(this.hints.size(), queryHint);
    }

    @Override
    public void removeHint(QueryHint queryHint) {
        this.removeHint(this.hints.indexOf(queryHint));
    }

    @Override
    public void removeHint(int index) {
        OrmQueryHint queryHint = this.hints.remove(index);
        this.getResourceQuery().getHints().remove(index);
        this.fireItemRemoved("hints", index, queryHint);
    }

    protected void removeHint_(OrmQueryHint queryHint) {
        this.removeItemFromList(queryHint, this.hints, "hints");
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.getResourceQuery().getHints().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.hints, "hints");
    }

    protected void initialize(E xmlQuery) {
        this.resourceQuery = xmlQuery;
        this.name = xmlQuery.getName();
        this.query = xmlQuery.getQuery();
        this.initializeHints();
        this.getPersistenceUnit().addQuery(this);
    }

    protected void initializeHints() {
        for (XmlQueryHint resourceQueryHint : this.resourceQuery.getHints()) {
            this.hints.add(this.buildQueryHint(resourceQueryHint));
        }
    }

    protected OrmQueryHint buildQueryHint(XmlQueryHint resourceQueryHint) {
        return this.getJpaFactory().buildOrmQueryHint(this, resourceQueryHint);
    }

    public void update(E xmlQuery) {
        this.resourceQuery = xmlQuery;
        this.setName(xmlQuery.getName());
        this.setQuery(xmlQuery.getQuery());
        this.updateHints();
        this.getPersistenceUnit().addQuery(this);
    }

    protected void updateHints() {
        ListIterator<OrmQueryHint> contextHints = this.hints();
        CloneListIterator resourceHints = new CloneListIterator(this.resourceQuery.getHints());
        while (contextHints.hasNext()) {
            OrmQueryHint contextHint = contextHints.next();
            if (resourceHints.hasNext()) {
                contextHint.update((XmlQueryHint)resourceHints.next());
                continue;
            }
            this.removeHint_(contextHint);
        }
        while (resourceHints.hasNext()) {
            this.addHint(this.buildQueryHint((XmlQueryHint)resourceHints.next()));
        }
    }

    @Override
    public boolean overrides(Query other) {
        return this.name != null && this.name.equals(other.getName()) && other instanceof JavaQuery;
    }

    @Override
    public boolean duplicates(Query other) {
        return this != other && !StringTools.stringIsEmpty((String)this.name) && this.name.equals(other.getName()) && !this.overrides(other) && !other.overrides(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getResourceQuery().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getResourceQuery().getNameTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

