/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericOrmQueryHint
extends AbstractXmlContextNode
implements OrmQueryHint {
    protected String name;
    protected String value;
    protected XmlQueryHint resourceQueryHint;

    public GenericOrmQueryHint(OrmQuery parent, XmlQueryHint resourceQueryHint) {
        super(parent);
        this.initialize(resourceQueryHint);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.resourceQueryHint.setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        this.resourceQueryHint.setValue(newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    protected void initialize(XmlQueryHint resourceQueryHint) {
        this.resourceQueryHint = resourceQueryHint;
        this.name = resourceQueryHint.getName();
        this.value = resourceQueryHint.getValue();
    }

    public void update(XmlQueryHint resourceQueryHint) {
        this.resourceQueryHint = resourceQueryHint;
        this.setName(resourceQueryHint.getName());
        this.setValue(resourceQueryHint.getValue());
    }

    public TextRange getValidationTextRange() {
        return this.resourceQueryHint.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

