/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.Cascade;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.CascadeType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;

public class OrmCascade
extends AbstractXmlContextNode
implements Cascade {
    protected boolean all;
    protected boolean persist;
    protected boolean merge;
    protected boolean remove;
    protected boolean refresh;
    protected XmlRelationshipMapping relationshipMapping;

    protected OrmCascade(OrmRelationshipMapping parent) {
        super(parent);
    }

    public void initializeFrom(Cascade oldCascade) {
        this.setAll(oldCascade.isAll());
        this.setPersist(oldCascade.isPersist());
        this.setMerge(oldCascade.isMerge());
        this.setRemove(oldCascade.isRemove());
        this.setRefresh(oldCascade.isRefresh());
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean newAll) {
        boolean oldAll = this.all;
        this.all = newAll;
        if (oldAll != newAll) {
            if (this.getCascadeResource() != null) {
                this.getCascadeResource().setCascadeAll(newAll);
                if (this.getCascadeResource().isAllFeaturesUnset()) {
                    this.removeCascadeResource();
                }
            } else if (newAll) {
                this.addCascadeResource();
                this.getCascadeResource().setCascadeAll(newAll);
            }
        }
        this.firePropertyChanged("allProperty", oldAll, newAll);
    }

    protected void setAll_(boolean newAll) {
        boolean oldAll = this.all;
        this.all = newAll;
        this.firePropertyChanged("allProperty", oldAll, newAll);
    }

    public boolean isPersist() {
        return this.persist;
    }

    public void setPersist(boolean newPersist) {
        boolean oldPersist = this.persist;
        this.persist = newPersist;
        if (oldPersist != newPersist) {
            if (this.getCascadeResource() != null) {
                this.getCascadeResource().setCascadePersist(newPersist);
                if (this.getCascadeResource().isAllFeaturesUnset()) {
                    this.removeCascadeResource();
                }
            } else if (newPersist) {
                this.addCascadeResource();
                this.getCascadeResource().setCascadePersist(newPersist);
            }
        }
        this.firePropertyChanged("persistProperty", oldPersist, newPersist);
    }

    protected void setPersist_(boolean newPersist) {
        boolean oldPersist = this.persist;
        this.persist = newPersist;
        this.firePropertyChanged("persistProperty", oldPersist, newPersist);
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean newMerge) {
        boolean oldMerge = this.merge;
        this.merge = newMerge;
        if (oldMerge != newMerge) {
            if (this.getCascadeResource() != null) {
                this.getCascadeResource().setCascadeMerge(newMerge);
                if (this.getCascadeResource().isAllFeaturesUnset()) {
                    this.removeCascadeResource();
                }
            } else if (newMerge) {
                this.addCascadeResource();
                this.getCascadeResource().setCascadeMerge(newMerge);
            }
        }
        this.firePropertyChanged("mergeProperty", oldMerge, newMerge);
    }

    protected void setMerge_(boolean newMerge) {
        boolean oldMerge = this.merge;
        this.merge = newMerge;
        this.firePropertyChanged("mergeProperty", oldMerge, newMerge);
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean newRemove) {
        boolean oldRemove = this.remove;
        this.remove = newRemove;
        if (oldRemove != newRemove) {
            if (this.getCascadeResource() != null) {
                this.getCascadeResource().setCascadeRemove(newRemove);
                if (this.getCascadeResource().isAllFeaturesUnset()) {
                    this.removeCascadeResource();
                }
            } else if (newRemove) {
                this.addCascadeResource();
                this.getCascadeResource().setCascadeRemove(newRemove);
            }
        }
        this.firePropertyChanged("removeProperty", oldRemove, newRemove);
    }

    protected void setRemove_(boolean newRemove) {
        boolean oldRemove = this.remove;
        this.remove = newRemove;
        this.firePropertyChanged("removeProperty", oldRemove, newRemove);
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean newRefresh) {
        boolean oldRefresh = this.refresh;
        this.refresh = newRefresh;
        if (oldRefresh != newRefresh) {
            if (this.getCascadeResource() != null) {
                this.getCascadeResource().setCascadeRefresh(newRefresh);
                if (this.getCascadeResource().isAllFeaturesUnset()) {
                    this.removeCascadeResource();
                }
            } else if (newRefresh) {
                this.addCascadeResource();
                this.getCascadeResource().setCascadeRefresh(newRefresh);
            }
        }
        this.firePropertyChanged("refreshProperty", oldRefresh, newRefresh);
    }

    protected void setRefresh_(boolean newRefresh) {
        boolean oldRefresh = this.refresh;
        this.refresh = newRefresh;
        this.firePropertyChanged("refreshProperty", oldRefresh, newRefresh);
    }

    protected CascadeType getCascadeResource() {
        return this.relationshipMapping.getCascade();
    }

    protected void removeCascadeResource() {
        this.relationshipMapping.setCascade(null);
    }

    protected void addCascadeResource() {
        this.relationshipMapping.setCascade(OrmFactory.eINSTANCE.createCascadeTypeImpl());
    }

    public void initialize(XmlRelationshipMapping relationshipMapping) {
        this.relationshipMapping = relationshipMapping;
        CascadeType cascade = this.getCascadeResource();
        this.all = this.all(cascade);
        this.persist = this.persist(cascade);
        this.merge = this.merge(cascade);
        this.remove = this.remove(cascade);
        this.refresh = this.refresh(cascade);
    }

    public void update() {
        CascadeType cascade = this.getCascadeResource();
        this.setAll_(this.all(cascade));
        this.setPersist_(this.persist(cascade));
        this.setMerge_(this.merge(cascade));
        this.setRemove_(this.remove(cascade));
        this.setRefresh_(this.refresh(cascade));
    }

    protected boolean all(CascadeType cascade) {
        return cascade == null ? false : cascade.isCascadeAll();
    }

    protected boolean persist(CascadeType cascade) {
        return cascade == null ? false : cascade.isCascadePersist();
    }

    protected boolean merge(CascadeType cascade) {
        return cascade == null ? false : cascade.isCascadeMerge();
    }

    protected boolean remove(CascadeType cascade) {
        return cascade == null ? false : cascade.isCascadeRemove();
    }

    protected boolean refresh(CascadeType cascade) {
        return cascade == null ? false : cascade.isCascadeRefresh();
    }

    public TextRange getValidationTextRange() {
        return this.getCascadeResource().getValidationTextRange();
    }
}

