/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentTypeContext;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericClassRef
extends AbstractXmlContextNode
implements ClassRef,
PersistentTypeContext {
    protected XmlJavaClassRef xmlJavaClassRef;
    protected String className;
    protected JavaPersistentType javaPersistentType;

    public GenericClassRef(PersistenceUnit parent, XmlJavaClassRef classRef) {
        super(parent);
        this.initialize(classRef);
    }

    public GenericClassRef(PersistenceUnit parent, String className) {
        super(parent);
        this.initialize(className);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.classRef";
    }

    @Override
    public boolean isFor(String fullyQualifiedTypeName) {
        if (this.getClassName() == null) {
            return false;
        }
        return this.getClassName().equals(fullyQualifiedTypeName);
    }

    @Override
    public boolean isVirtual() {
        return this.xmlJavaClassRef == null;
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String newClassName) {
        String oldClassName = this.className;
        this.className = newClassName;
        this.xmlJavaClassRef.setJavaClass(newClassName);
        this.firePropertyChanged("className", oldClassName, newClassName);
    }

    protected void setClassName_(String newClassName) {
        String oldClassName = this.className;
        this.className = newClassName;
        this.firePropertyChanged("className", oldClassName, newClassName);
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType newJavaPersistentType) {
        JavaPersistentType oldJavaPersistentType = this.javaPersistentType;
        this.javaPersistentType = newJavaPersistentType;
        this.firePropertyChanged("javaPersistentType", oldJavaPersistentType, newJavaPersistentType);
    }

    protected void initialize(XmlJavaClassRef classRef) {
        this.xmlJavaClassRef = classRef;
        this.className = classRef.getJavaClass();
        this.initializeJavaPersistentType();
    }

    protected void initialize(String className) {
        this.className = className;
        this.initializeJavaPersistentType();
    }

    protected void initializeJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJpaProject().getJavaResourcePersistentType(this.getClassName());
        if (jrpt != null) {
            this.javaPersistentType = this.buildJavaPersistentType(jrpt);
        }
    }

    @Override
    public void update(XmlJavaClassRef classRef) {
        this.xmlJavaClassRef = classRef;
        this.setClassName_(classRef.getJavaClass());
        this.updateJavaPersistentType();
    }

    @Override
    public void update(String className) {
        this.xmlJavaClassRef = null;
        this.setClassName_(className);
        this.updateJavaPersistentType();
    }

    protected void updateJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJpaProject().getJavaResourcePersistentType(this.getClassName());
        if (jrpt == null) {
            if (this.getJavaPersistentType() != null) {
                this.getJavaPersistentType().dispose();
            }
            this.setJavaPersistentType(null);
        } else if (this.getJavaPersistentType() != null) {
            this.getJavaPersistentType().update(jrpt);
        } else {
            this.setJavaPersistentType(this.buildJavaPersistentType(jrpt));
        }
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (StringTools.stringIsEmpty((String)this.className)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_CLASS", this, this.getValidationTextRange()));
            return;
        }
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_CLASS", new String[]{this.className}, this, this.getValidationTextRange()));
            return;
        }
        MappingFileRef mappingFileRef = this.getMappingFileContaining(this.className);
        if (mappingFileRef != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "PERSISTENCE_UNIT_REDUNDANT_CLASS", new String[]{this.className, mappingFileRef.getFileName()}, this, this.getValidationTextRange()));
            return;
        }
        this.validateJavaPersistentType(messages);
    }

    protected void validateJavaPersistentType(List<IMessage> messages) {
        try {
            this.javaPersistentType.validate(messages);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected MappingFileRef getMappingFileContaining(String fullyQualifiedTypeName) {
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.getPersistenceUnit().mappingFileRefs())) {
            if (mappingFileRef.getPersistentType(fullyQualifiedTypeName) == null) continue;
            return mappingFileRef;
        }
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.isVirtual()) {
            return false;
        }
        return this.xmlJavaClassRef.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        if (this.isVirtual()) {
            return null;
        }
        return this.xmlJavaClassRef.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        if (this.isVirtual()) {
            return null;
        }
        return this.xmlJavaClassRef.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getClassName());
    }

    @Override
    public void dispose() {
        if (this.getJavaPersistentType() != null) {
            this.getJavaPersistentType().dispose();
        }
    }
}

