/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.MappingFile;
import org.eclipse.jpt.core.context.MappingFilePersistenceUnitDefaults;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.resource.JpaResourceModelProviderManager;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.JpaResourceModelProvider;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMappingFileRef
extends AbstractXmlContextNode
implements MappingFileRef {
    protected XmlMappingFileRef xmlMappingFileRef;
    protected String fileName;
    protected MappingFile mappingFile;

    public GenericMappingFileRef(PersistenceUnit parent, XmlMappingFileRef mappingFileRef) {
        super(parent);
        this.initialize(mappingFileRef);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.mappingFileRef";
    }

    @Override
    public boolean isVirtual() {
        return this.xmlMappingFileRef == null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String newFileName) {
        this.xmlMappingFileRef.setFileName(newFileName);
        this.setFileName_(newFileName);
    }

    protected void setFileName_(String newFileName) {
        String oldFileName = this.fileName;
        this.fileName = newFileName;
        this.firePropertyChanged("fileName", oldFileName, newFileName);
    }

    @Override
    public MappingFile getMappingFile() {
        return this.mappingFile;
    }

    protected void setMappingFile(MappingFile newMappingFile) {
        MappingFile oldMappingFile = this.mappingFile;
        this.mappingFile = newMappingFile;
        this.firePropertyChanged("mappingFile", oldMappingFile, newMappingFile);
    }

    protected void initialize(XmlMappingFileRef mappingFileRef) {
        this.xmlMappingFileRef = mappingFileRef;
        this.initializeFileName();
        this.initializeMappingFile();
    }

    protected void initializeFileName() {
        this.fileName = this.isVirtual() ? "META-INF/orm.xml" : this.xmlMappingFileRef.getFileName();
    }

    protected void initializeMappingFile() {
        IFile platformFile = this.getPlatformFile();
        if (platformFile != null && platformFile.exists()) {
            JpaXmlResource resource;
            JpaResourceModelProvider modelProvider = JpaResourceModelProviderManager.instance().getModelProvider(platformFile);
            JpaXmlResource jpaXmlResource = resource = modelProvider == null ? null : modelProvider.getResource();
            if (resource != null && resource.exists()) {
                this.mappingFile = this.buildMappingFile(resource);
            }
        }
    }

    @Override
    public void update(XmlMappingFileRef mappingFileRef) {
        this.xmlMappingFileRef = mappingFileRef;
        this.updateFileName();
        this.updateMappingFile();
    }

    protected void updateFileName() {
        if (this.isVirtual()) {
            this.setFileName_("META-INF/orm.xml");
        } else {
            this.setFileName_(this.xmlMappingFileRef.getFileName());
        }
    }

    protected void updateMappingFile() {
        IFile platformFile = this.getPlatformFile();
        if (platformFile != null && platformFile.exists()) {
            JpaXmlResource resource;
            JpaResourceModelProvider modelProvider = JpaResourceModelProviderManager.instance().getModelProvider(platformFile);
            JpaXmlResource jpaXmlResource = resource = modelProvider == null ? null : modelProvider.getResource();
            if (resource != null && resource.exists()) {
                if (this.mappingFile != null && !((Object)((Object)resource)).equals((Object)this.mappingFile.getXmlResource())) {
                    this.mappingFile.dispose();
                }
                if (this.mappingFile == null) {
                    this.setMappingFile(this.buildMappingFile(resource));
                } else {
                    this.mappingFile.update(resource);
                }
                return;
            }
        }
        if (this.mappingFile != null) {
            this.mappingFile.dispose();
            this.setMappingFile(null);
        }
    }

    protected IFile getPlatformFile() {
        if (this.fileName == null) {
            return null;
        }
        IProject project = this.getJpaProject().getProject();
        IVirtualFile vFile = ComponentCore.createFile((IProject)project, (IPath)new Path(JptCorePlugin.getDeploymentURI(project, this.fileName)));
        return vFile.getUnderlyingFile();
    }

    protected MappingFile buildMappingFile(JpaXmlResource resource) {
        XmlContextNode context = this.getJpaFactory().buildContextNode(this, resource);
        try {
            return (MappingFile)context;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public MappingFilePersistenceUnitDefaults getPersistenceUnitDefaults() {
        if (this.mappingFile != null && this.mappingFile.getRoot() != null) {
            return this.mappingFile.getRoot().getPersistenceUnitDefaults();
        }
        return null;
    }

    @Override
    public PersistentType getPersistentType(String fullyQualifiedTypeName) {
        if (this.mappingFile != null) {
            return this.mappingFile.getPersistentType(fullyQualifiedTypeName);
        }
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.xmlMappingFileRef == null) {
            return false;
        }
        return this.xmlMappingFileRef.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        if (this.isVirtual()) {
            return null;
        }
        return this.xmlMappingFileRef.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        if (this.isVirtual()) {
            return this.getPersistenceUnit().getValidationTextRange();
        }
        return this.xmlMappingFileRef.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.fileName);
    }

    @Override
    public void dispose() {
        if (this.mappingFile != null) {
            this.mappingFile.dispose();
        }
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (StringTools.stringIsEmpty((String)this.fileName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE", this, this.getValidationTextRange()));
            return;
        }
        if (this.mappingFile == null) {
            IFile platformFile = this.getPlatformFile();
            if (platformFile != null && platformFile.exists()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSUPPORTED_MAPPING_FILE_CONTENT", new String[]{this.fileName}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE", new String[]{this.fileName}, this, this.getValidationTextRange()));
            }
            return;
        }
        if (this.mappingFile.getRoot() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_INVALID_MAPPING_FILE", new String[]{this.fileName}, this, this.getValidationTextRange()));
        }
        this.mappingFile.validate(messages);
    }
}

