/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.resource.JpaResourceModelProvider;
import org.eclipse.jpt.core.resource.JpaResourceModelProviderFactory;
import org.eclipse.jpt.core.utility.PlatformUtilities;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaResourceModelProviderManager {
    private final HashMap<String, FactoryProvider> factoryProviders = this.buildFactoryProviders();
    private static final String EXTENSION_ID = "resourceModelProviders";
    private static final String EL_MODEL_PROVIDER = "modelProvider";
    private static final String AT_FILE_CONTENT_TYPE = "fileContentType";
    private static final String AT_FACTORY_CLASS = "factoryClass";
    private static final JpaResourceModelProviderManager INSTANCE = new JpaResourceModelProviderManager();

    public static JpaResourceModelProviderManager instance() {
        return INSTANCE;
    }

    private JpaResourceModelProviderManager() {
    }

    private HashMap<String, FactoryProvider> buildFactoryProviders() {
        HashMap<String, FactoryProvider> providers = new HashMap<String, FactoryProvider>();
        Iterator<IConfigurationElement> stream = this.configElements();
        while (stream.hasNext()) {
            this.addFactoryProviderTo(stream.next(), providers);
        }
        return providers;
    }

    private Iterator<IConfigurationElement> configElements() {
        return new CompositeIterator(this.configElementIterators());
    }

    private Iterator<Iterator<IConfigurationElement>> configElementIterators() {
        return new TransformationIterator<IExtension, Iterator<IConfigurationElement>>(this.extensions()){

            protected Iterator<IConfigurationElement> transform(IExtension extension) {
                return CollectionTools.iterator((Object[])extension.getConfigurationElements());
            }
        };
    }

    private Iterator<IExtension> extensions() {
        return CollectionTools.iterator((Object[])this.getExtensionPoint().getExtensions());
    }

    private IExtensionPoint getExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jpt.core", EXTENSION_ID);
    }

    private void addFactoryProviderTo(IConfigurationElement configElement, HashMap<String, FactoryProvider> providers) {
        if (!configElement.getName().equals(EL_MODEL_PROVIDER)) {
            return;
        }
        boolean missingAttribute = false;
        String fileContentType = configElement.getAttribute(AT_FILE_CONTENT_TYPE);
        if (fileContentType == null) {
            JpaResourceModelProviderManager.logMissingAttribute(configElement, AT_FILE_CONTENT_TYPE);
            missingAttribute = false;
        }
        if (configElement.getAttribute(AT_FACTORY_CLASS) == null) {
            JpaResourceModelProviderManager.logMissingAttribute(configElement, AT_FACTORY_CLASS);
            missingAttribute = false;
        }
        if (missingAttribute) {
            return;
        }
        FactoryProvider prev = providers.get(fileContentType);
        if (prev == null) {
            providers.put(fileContentType, new FactoryProvider(configElement));
        } else {
            JpaResourceModelProviderManager.logDuplicateFileContentType(prev.getConfigurationElement(), configElement);
        }
    }

    public JpaResourceModelProvider getModelProvider(IFile file) {
        IProject project = file.getProject();
        IPath path = file.getFullPath();
        IContentType contentType = PlatformUtilities.getContentType(file);
        while (contentType != null) {
            JpaResourceModelProvider modelProvider = this.getModelProvider(project, path, contentType.getId());
            if (modelProvider != null) {
                return modelProvider;
            }
            contentType = contentType.getBaseType();
        }
        return null;
    }

    public JpaResourceModelProvider getModelProvider(IProject project, IPath filePath, String fileContentType) {
        JpaResourceModelProviderFactory factory = this.getFactory(fileContentType);
        return factory == null ? null : factory.create(project, filePath);
    }

    private JpaResourceModelProviderFactory getFactory(String fileContentType) {
        FactoryProvider fp = this.factoryProviders.get(fileContentType);
        return fp == null ? null : fp.getFactory();
    }

    private static void logMissingAttribute(IConfigurationElement configElement, String attributeName) {
        JptCorePlugin.log(NLS.bind((String)JptCoreMessages.RESOURCE_MODEL_PROVIDER_REGISTRY_MISSING_ATTRIBUTE, (Object[])new String[]{configElement.getName(), configElement.getContributor().getName(), attributeName}));
    }

    private static void logDuplicateFileContentType(IConfigurationElement configElement1, IConfigurationElement configElement2) {
        JptCorePlugin.log(NLS.bind((String)JptCoreMessages.RESOURCE_MODEL_PROVIDER_REGISTRY_DUPLICATE_FILE_CONTENT_TYPE, (Object[])new String[]{configElement1.getContributor().getName(), configElement2.getContributor().getName(), AT_FILE_CONTENT_TYPE, EL_MODEL_PROVIDER, configElement1.getAttribute(AT_FILE_CONTENT_TYPE)}));
    }

    private static class FactoryProvider {
        private final IConfigurationElement configurationElement;
        private JpaResourceModelProviderFactory factory;
        private boolean factoryBuilt;

        FactoryProvider(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
            this.factoryBuilt = false;
        }

        IConfigurationElement getConfigurationElement() {
            return this.configurationElement;
        }

        synchronized JpaResourceModelProviderFactory getFactory() {
            if (!this.factoryBuilt) {
                this.factoryBuilt = true;
                this.factory = this.buildFactory();
            }
            return this.factory;
        }

        private JpaResourceModelProviderFactory buildFactory() {
            try {
                return (JpaResourceModelProviderFactory)this.configurationElement.createExecutableExtension(JpaResourceModelProviderManager.AT_FACTORY_CLASS);
            }
            catch (CoreException ex) {
                this.logFailedInstantiation(ex);
                return null;
            }
        }

        private void logFailedInstantiation(CoreException ex) {
            JptCorePlugin.log(ex);
            JptCorePlugin.log(NLS.bind((String)JptCoreMessages.RESOURCE_MODEL_PROVIDER_REGISTRY_FAILED_INSTANTIATION, (Object[])new String[]{this.configurationElement.getAttribute(JpaResourceModelProviderManager.AT_FACTORY_CLASS), this.configurationElement.getName(), this.configurationElement.getContributor().getName()}));
        }
    }
}

