/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraint;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceTable
extends AbstractResourceAnnotation<Member>
implements TableAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> schemaDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> catalogDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> schemaAdapter;
    private final AnnotationElementAdapter<String> catalogAdapter;
    private String name;
    private String catalog;
    private String schema;
    final List<NestableUniqueConstraint> uniqueConstraints;
    private final UniqueConstraintsContainerAnnotation uniqueConstraintsContainerAnnotation;

    protected AbstractResourceTable(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.getNameAdapter(daa);
        this.schemaDeclarationAdapter = this.getSchemaAdapter(daa);
        this.catalogDeclarationAdapter = this.getCatalogAdapter(daa);
        this.nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
        this.schemaAdapter = this.buildAnnotationElementAdapter(this.schemaDeclarationAdapter);
        this.catalogAdapter = this.buildAnnotationElementAdapter(this.catalogDeclarationAdapter);
        this.uniqueConstraints = new ArrayList<NestableUniqueConstraint>();
        this.uniqueConstraintsContainerAnnotation = new UniqueConstraintsContainerAnnotation();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.catalog = this.catalog(astRoot);
        this.schema = this.schema(astRoot);
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this.uniqueConstraintsContainerAnnotation);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>((Member)this.getMember(), daea);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> getNameAdapter(DeclarationAnnotationAdapter var1);

    protected abstract DeclarationAnnotationElementAdapter<String> getSchemaAdapter(DeclarationAnnotationAdapter var1);

    protected abstract DeclarationAnnotationElementAdapter<String> getCatalogAdapter(DeclarationAnnotationAdapter var1);

    protected abstract String getUniqueConstraintsElementName();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue(newName);
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String newCatalog) {
        if (this.attributeValueHasNotChanged(this.catalog, newCatalog)) {
            return;
        }
        String oldCatalog = this.catalog;
        this.catalog = newCatalog;
        this.catalogAdapter.setValue(newCatalog);
        this.firePropertyChanged("catalog", oldCatalog, newCatalog);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String newSchema) {
        if (this.attributeValueHasNotChanged(this.schema, newSchema)) {
            return;
        }
        String oldSchema = this.schema;
        this.schema = newSchema;
        this.schemaAdapter.setValue(newSchema);
        this.firePropertyChanged("schema", oldSchema, newSchema);
    }

    @Override
    public ListIterator<UniqueConstraintAnnotation> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public NestableUniqueConstraint uniqueConstraintAt(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public int indexOfUniqueConstraint(UniqueConstraintAnnotation uniqueConstraint) {
        return this.uniqueConstraints.indexOf(uniqueConstraint);
    }

    @Override
    public NestableUniqueConstraint addUniqueConstraint(int index) {
        NestableUniqueConstraint uniqueConstraint = (NestableUniqueConstraint)ContainerAnnotationTools.addNestedAnnotation(index, this.uniqueConstraintsContainerAnnotation);
        this.fireItemAdded("uniqueConstraints", index, uniqueConstraint);
        return uniqueConstraint;
    }

    protected void addUniqueConstraint(int index, NestableUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void removeUniqueConstraint(int index) {
        NestableUniqueConstraint uniqueConstraint = this.uniqueConstraintAt(index);
        this.removeUniqueConstraint(uniqueConstraint);
        uniqueConstraint.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, this.uniqueConstraintsContainerAnnotation);
    }

    protected void removeUniqueConstraint(NestableUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.moveUniqueConstraintInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, this.uniqueConstraintsContainerAnnotation);
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    protected void moveUniqueConstraintInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
    }

    protected abstract NestableUniqueConstraint createUniqueConstraint(int var1);

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.schemaDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.catalogDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.catalogDeclarationAdapter, pos, astRoot);
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.schemaDeclarationAdapter, pos, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setSchema(this.schema(astRoot));
        this.setCatalog(this.catalog(astRoot));
        this.updateUniqueConstraintsFromJava(astRoot);
    }

    protected String name(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    protected String schema(CompilationUnit astRoot) {
        return this.schemaAdapter.getValue(astRoot);
    }

    protected String catalog(CompilationUnit astRoot) {
        return this.catalogAdapter.getValue(astRoot);
    }

    private void updateUniqueConstraintsFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this.uniqueConstraintsContainerAnnotation);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UniqueConstraintsContainerAnnotation
    extends AbstractJavaResourceNode
    implements ContainerAnnotation<NestableUniqueConstraint> {
        public UniqueConstraintsContainerAnnotation() {
            super(AbstractResourceTable.this);
        }

        @Override
        public void initialize(CompilationUnit astRoot) {
        }

        @Override
        public NestableUniqueConstraint addInternal(int index) {
            NestableUniqueConstraint uniqueConstraint = AbstractResourceTable.this.createUniqueConstraint(index);
            AbstractResourceTable.this.uniqueConstraints.add(index, uniqueConstraint);
            return uniqueConstraint;
        }

        @Override
        public NestableUniqueConstraint add(int index) {
            NestableUniqueConstraint uniqueConstraint = AbstractResourceTable.this.createUniqueConstraint(index);
            AbstractResourceTable.this.addUniqueConstraint(index, uniqueConstraint);
            return uniqueConstraint;
        }

        @Override
        public String getAnnotationName() {
            return AbstractResourceTable.this.getAnnotationName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        @Override
        public int indexOf(NestableUniqueConstraint uniqueConstraint) {
            return AbstractResourceTable.this.indexOfUniqueConstraint(uniqueConstraint);
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            AbstractResourceTable.this.moveUniqueConstraint(targetIndex, sourceIndex);
        }

        @Override
        public void moveInternal(int targetIndex, int sourceIndex) {
            AbstractResourceTable.this.moveUniqueConstraintInternal(targetIndex, sourceIndex);
        }

        @Override
        public NestableUniqueConstraint nestedAnnotationAt(int index) {
            return AbstractResourceTable.this.uniqueConstraintAt(index);
        }

        @Override
        public NestableUniqueConstraint nestedAnnotationFor(Annotation jdtAnnotation) {
            for (NestableUniqueConstraint uniqueConstraint : CollectionTools.iterable(this.nestedAnnotations())) {
                if (jdtAnnotation != uniqueConstraint.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
                return uniqueConstraint;
            }
            return null;
        }

        @Override
        public ListIterator<NestableUniqueConstraint> nestedAnnotations() {
            return new CloneListIterator(AbstractResourceTable.this.uniqueConstraints);
        }

        @Override
        public int nestedAnnotationsSize() {
            return AbstractResourceTable.this.uniqueConstraintsSize();
        }

        @Override
        public void remove(NestableUniqueConstraint uniqueConstraint) {
            AbstractResourceTable.this.removeUniqueConstraint(uniqueConstraint);
        }

        @Override
        public void remove(int index) {
            this.remove(this.nestedAnnotationAt(index));
        }

        @Override
        public Annotation getJdtAnnotation(CompilationUnit astRoot) {
            return AbstractResourceTable.this.getJdtAnnotation(astRoot);
        }

        @Override
        public void newAnnotation() {
            AbstractResourceTable.this.newAnnotation();
        }

        @Override
        public void removeAnnotation() {
            AbstractResourceTable.this.removeAnnotation();
        }

        @Override
        public void update(CompilationUnit astRoot) {
            AbstractResourceTable.this.update(astRoot);
        }

        @Override
        public TextRange getTextRange(CompilationUnit astRoot) {
            return AbstractResourceTable.this.getTextRange(astRoot);
        }

        @Override
        public String getElementName() {
            return AbstractResourceTable.this.getUniqueConstraintsElementName();
        }

        public void toString(StringBuilder sb) {
            AbstractResourceTable.this.toString(sb);
        }
    }
}

