/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractNamedQuery;
import org.eclipse.jpt.core.internal.resource.java.QueryHintImpl;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableNamedNativeQuery;
import org.eclipse.jpt.core.resource.java.NestableQueryHint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedNativeQueryImpl
extends AbstractNamedQuery
implements NestableNamedNativeQuery {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedNativeQuery");
    private final DeclarationAnnotationElementAdapter<String> resultClassDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> resultSetMappingDeclarationAdapter;
    private final AnnotationElementAdapter<String> resultClassAdapter;
    private final AnnotationElementAdapter<String> resultSetMappingAdapter;
    private String resultClass;
    private String fullyQualifiedResultClass;
    private String resultSetMapping;

    protected NamedNativeQueryImpl(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, type, daa, annotationAdapter);
        this.resultClassDeclarationAdapter = this.resultClassAdapter(daa);
        this.resultClassAdapter = this.buildAdapter(this.resultClassDeclarationAdapter);
        this.resultSetMappingDeclarationAdapter = this.resultSetMappingAdapter(daa);
        this.resultSetMappingAdapter = this.buildAdapter(this.resultSetMappingDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.resultClass = this.resultClass(astRoot);
        this.fullyQualifiedResultClass = this.fullyQualifiedResultClass(astRoot);
        this.resultSetMapping = this.resultSetMapping(astRoot);
    }

    protected DeclarationAnnotationElementAdapter<String> resultClassAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(daa, "resultClass", SimpleTypeStringExpressionConverter.instance());
    }

    protected DeclarationAnnotationElementAdapter<String> resultSetMappingAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, "resultSetMapping");
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.NamedNativeQuery";
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    protected String getQueryElementName() {
        return "query";
    }

    @Override
    protected String getHintsElementName() {
        return "hints";
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        NamedNativeQueryAnnotation oldNamedQuery = (NamedNativeQueryAnnotation)((Object)oldAnnotation);
        this.setResultClass(oldNamedQuery.getResultClass());
        this.setResultSetMapping(oldNamedQuery.getResultSetMapping());
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public void setResultClass(String newResultClass) {
        if (this.attributeValueHasNotChanged(this.resultClass, newResultClass)) {
            return;
        }
        String oldResultClass = this.resultClass;
        this.resultClass = newResultClass;
        this.resultClassAdapter.setValue(newResultClass);
        this.firePropertyChanged("resultClassProperty", oldResultClass, newResultClass);
    }

    @Override
    public String getFullyQualifiedResultClass() {
        return this.fullyQualifiedResultClass;
    }

    protected void setFullyQualifiedResultClass(String newQualifiedResultClass) {
        String oldFullyQualifiedResultClass = this.fullyQualifiedResultClass;
        this.fullyQualifiedResultClass = newQualifiedResultClass;
        this.firePropertyChanged("fullyQualifiedResultClassProperty", oldFullyQualifiedResultClass, newQualifiedResultClass);
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public void setResultSetMapping(String newResultSetMapping) {
        if (this.attributeValueHasNotChanged(this.resultSetMapping, newResultSetMapping)) {
            return;
        }
        String oldResultSetMapping = this.resultSetMapping;
        this.resultSetMapping = newResultSetMapping;
        this.resultSetMappingAdapter.setValue(newResultSetMapping);
        this.firePropertyChanged("resultSetMappingProperty", oldResultSetMapping, newResultSetMapping);
    }

    @Override
    public TextRange getResultClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultClassDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getResultSetMappingTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultSetMappingDeclarationAdapter, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setResultClass(this.resultClass(astRoot));
        this.setFullyQualifiedResultClass(this.fullyQualifiedResultClass(astRoot));
        this.setResultSetMapping(this.resultSetMapping(astRoot));
    }

    protected String resultClass(CompilationUnit astRoot) {
        return this.resultClassAdapter.getValue(astRoot);
    }

    protected String resultSetMapping(CompilationUnit astRoot) {
        return this.resultSetMappingAdapter.getValue(astRoot);
    }

    protected String fullyQualifiedResultClass(CompilationUnit astRoot) {
        if (this.getResultClass() == null) {
            return null;
        }
        return JDTTools.resolveFullyQualifiedName(this.resultClassAdapter.getExpression(astRoot));
    }

    @Override
    protected NestableQueryHint createQueryHint(int index) {
        return QueryHintImpl.createNamedNativeQueryQueryHint(this, (Type)this.getMember(), this.getDeclarationAnnotationAdapter(), index);
    }

    static NamedNativeQueryImpl createNamedNativeQuery(JavaResourceNode parent, Type type) {
        return new NamedNativeQueryImpl(parent, type, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(type, DECLARATION_ANNOTATION_ADAPTER));
    }

    static NamedNativeQueryImpl createNestedNamedNativeQuery(JavaResourceNode parent, Type type, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = NamedNativeQueryImpl.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter((Member)type, idaa);
        return new NamedNativeQueryImpl(parent, type, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter namedQueriesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedQueriesAdapter, index, "javax.persistence.NamedNativeQuery");
    }

    public static class NamedNativeQueryAnnotationDefinition
    implements AnnotationDefinition {
        private static final NamedNativeQueryAnnotationDefinition INSTANCE = new NamedNativeQueryAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private NamedNativeQueryAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return NamedNativeQueryImpl.createNamedNativeQuery(parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.NamedNativeQuery";
        }
    }
}

