/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.GeneratorImpl;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceGeneratorImpl
extends GeneratorImpl
implements SequenceGeneratorAnnotation {
    private final AnnotationElementAdapter<String> sequenceNameAdapter = this.buildAdapter(SEQUENCE_NAME_ADAPTER);
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.SequenceGenerator");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SequenceGeneratorImpl.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = SequenceGeneratorImpl.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = SequenceGeneratorImpl.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> SEQUENCE_NAME_ADAPTER = SequenceGeneratorImpl.buildAdapter("sequenceName");
    private String sequenceName;

    protected SequenceGeneratorImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.sequenceName = this.sequenceName(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.SequenceGenerator";
    }

    @Override
    protected DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public void setSequenceName(String newSequenceName) {
        if (this.attributeValueHasNotChanged(this.sequenceName, newSequenceName)) {
            return;
        }
        String oldSequenceName = this.sequenceName;
        this.sequenceName = newSequenceName;
        this.sequenceNameAdapter.setValue(newSequenceName);
        this.firePropertyChanged("sequenceName", oldSequenceName, newSequenceName);
    }

    @Override
    public TextRange getSequenceNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SEQUENCE_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean sequenceNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(SEQUENCE_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setSequenceName(this.sequenceName(astRoot));
    }

    protected String sequenceName(CompilationUnit astRoot) {
        return this.sequenceNameAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SequenceGeneratorImpl.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return SequenceGeneratorImpl.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    public static class SequenceGeneratorAnnotationDefinition
    implements AnnotationDefinition {
        private static final SequenceGeneratorAnnotationDefinition INSTANCE = new SequenceGeneratorAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private SequenceGeneratorAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new SequenceGeneratorImpl(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.SequenceGenerator";
        }
    }
}

