/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jpt.utility.JavaType;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.SimpleJavaType;
import org.eclipse.jpt.utility.internal.SimpleMethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTTools {
    public static CompilationUnit buildASTRoot(ICompilationUnit compilationUnit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        return (CompilationUnit)parser.createAST(null);
    }

    public static String resolveEnum(Expression expression) {
        if (expression == null) {
            return null;
        }
        switch (expression.getNodeType()) {
            case 40: 
            case 42: {
                return JDTTools.resolveEnum((Name)expression);
            }
        }
        return null;
    }

    public static String resolveEnum(Name enumExpression) {
        IBinding binding = enumExpression.resolveBinding();
        if (binding == null) {
            return null;
        }
        if (binding.getKind() != 3) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        return String.valueOf(variableBinding.getType().getQualifiedName()) + '.' + variableBinding.getName();
    }

    public static String resolveAnnotation(Annotation node) {
        IAnnotationBinding annotationBinding = node.resolveAnnotationBinding();
        if (annotationBinding == null) {
            return null;
        }
        ITypeBinding annotationTypeBinding = annotationBinding.getAnnotationType();
        if (annotationTypeBinding == null) {
            return null;
        }
        return annotationTypeBinding.getQualifiedName();
    }

    public static String resolveFullyQualifiedName(Expression expression) {
        ITypeBinding resolvedTypeBinding = JDTTools.resolveTypeBinding(expression);
        if (resolvedTypeBinding != null) {
            return resolvedTypeBinding.getQualifiedName();
        }
        return null;
    }

    public static ITypeBinding resolveTypeBinding(Expression expression) {
        if (expression.getNodeType() == 57) {
            return ((TypeLiteral)expression).getType().resolveBinding();
        }
        return null;
    }

    public static MethodSignature buildMethodSignature(MethodDeclaration methodDeclaration) {
        return new SimpleMethodSignature(methodDeclaration.getName().getFullyQualifiedName(), JDTTools.buildParameterTypes(methodDeclaration));
    }

    public static JavaType[] buildParameterTypes(MethodDeclaration methodDeclaration) {
        List<SingleVariableDeclaration> parameters = JDTTools.parameters(methodDeclaration);
        int len = parameters.size();
        JavaType[] parameterTypes = new JavaType[len];
        int i = 0;
        while (i < len) {
            ITypeBinding type = parameters.get(i).getType().resolveBinding();
            parameterTypes[i] = new SimpleJavaType(type.getQualifiedName(), type.getDimensions());
            ++i;
        }
        return parameterTypes;
    }

    private static List<SingleVariableDeclaration> parameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    public static ITypeBinding findTypeInHierarchy(Expression expression, String fullyQualifiedTypeName) {
        ITypeBinding typeBinding = JDTTools.resolveTypeBinding(expression);
        if (typeBinding != null) {
            return JDTTools.findTypeInHierarchy(typeBinding, fullyQualifiedTypeName);
        }
        return null;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding hierarchyType, String fullyQualifiedTypeName) {
        ITypeBinding res;
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return null;
        }
        if (fullyQualifiedTypeName.equals(hierarchyType.getQualifiedName())) {
            return hierarchyType;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && (res = JDTTools.findTypeInHierarchy(superClass, fullyQualifiedTypeName)) != null) {
            return res;
        }
        ITypeBinding[] superInterfaces = hierarchyType.getInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            ITypeBinding res2 = JDTTools.findTypeInHierarchy(superInterfaces[i], fullyQualifiedTypeName);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }
}

