/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.db.internal.DTPForeignKeyWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPTableWrapper
extends DTPDatabaseObjectWrapper
implements Table {
    private final org.eclipse.datatools.modelbase.sql.tables.Table dtpTable;
    private DTPColumnWrapper[] columns;
    private DTPColumnWrapper[] primaryKeyColumns;
    private DTPForeignKeyWrapper[] foreignKeys;
    private static final DTPColumnWrapper[] EMPTY_COLUMNS = new DTPColumnWrapper[0];
    private static final DTPForeignKeyWrapper[] EMPTY_FOREIGN_KEYS = new DTPForeignKeyWrapper[0];

    DTPTableWrapper(DTPSchemaWrapper schema, org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        super(schema, dtpTable);
        this.dtpTable = dtpTable;
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().tableChanged(this);
    }

    @Override
    public String getName() {
        return this.dtpTable.getName();
    }

    @Override
    public DTPSchemaWrapper getSchema() {
        return (DTPSchemaWrapper)this.getParent();
    }

    @Override
    public Iterator<Column> columns() {
        return new ArrayIterator((Object[])this.getColumns());
    }

    private Iterator<DTPColumnWrapper> columnWrappers() {
        return new ArrayIterator((Object[])this.getColumns());
    }

    private synchronized DTPColumnWrapper[] getColumns() {
        if (this.columns == null) {
            this.columns = this.buildColumns();
        }
        return this.columns;
    }

    private DTPColumnWrapper[] buildColumns() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpColumns = this.getDTPColumns();
        Object[] result = new DTPColumnWrapper[dtpColumns.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPColumnWrapper(this, dtpColumns.get(i));
        }
        return (DTPColumnWrapper[])CollectionTools.sort((Object[])result);
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPColumns() {
        return this.dtpTable.getColumns();
    }

    @Override
    public int columnsSize() {
        return this.getColumns().length;
    }

    @Override
    public DTPColumnWrapper getColumnNamed(String name) {
        return (DTPColumnWrapper)this.selectDatabaseObjectNamed(this.getColumns(), name);
    }

    DTPColumnWrapper getColumn(org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        return this.wraps(dtpColumn.getTable()) ? this.getColumn_(dtpColumn) : this.getSchema().getColumn(dtpColumn);
    }

    DTPColumnWrapper getColumn_(org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        DTPColumnWrapper[] dTPColumnWrapperArray = this.getColumns();
        int n = dTPColumnWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            if (column.wraps(dtpColumn)) {
                return column;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP column: " + dtpColumn);
    }

    @Override
    public Iterator<String> sortedColumnIdentifiers() {
        return new TransformationIterator<DTPColumnWrapper, String>(this.columnWrappers()){

            protected String transform(DTPColumnWrapper next) {
                return next.getIdentifier();
            }
        };
    }

    @Override
    public DTPColumnWrapper getColumnForIdentifier(String identifier) {
        return (DTPColumnWrapper)this.selectDatabaseObjectForIdentifier(this.getColumns(), identifier);
    }

    @Override
    public Iterator<Column> primaryKeyColumns() {
        return new ArrayIterator((Object[])this.getPrimaryKeyColumns());
    }

    @Override
    public DTPColumnWrapper getPrimaryKeyColumn() {
        DTPColumnWrapper[] pkColumns = this.getPrimaryKeyColumns();
        if (pkColumns.length != 1) {
            throw new IllegalStateException("multiple primary key columns: " + pkColumns.length);
        }
        return pkColumns[0];
    }

    private synchronized DTPColumnWrapper[] getPrimaryKeyColumns() {
        if (this.primaryKeyColumns == null) {
            this.primaryKeyColumns = this.buildPrimaryKeyColumns();
        }
        return this.primaryKeyColumns;
    }

    private DTPColumnWrapper[] buildPrimaryKeyColumns() {
        if (!(this.dtpTable instanceof BaseTable)) {
            return EMPTY_COLUMNS;
        }
        PrimaryKey pk = ((BaseTable)this.dtpTable).getPrimaryKey();
        if (pk == null) {
            return EMPTY_COLUMNS;
        }
        List<org.eclipse.datatools.modelbase.sql.tables.Column> pkColumns = this.getColumns(pk);
        DTPColumnWrapper[] result = new DTPColumnWrapper[pkColumns.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = this.getColumn(pkColumns.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getColumns(PrimaryKey pk) {
        return pk.getMembers();
    }

    @Override
    public int primaryKeyColumnsSize() {
        return this.getPrimaryKeyColumns().length;
    }

    boolean primaryKeyColumnsContains(Column column) {
        return CollectionTools.contains((Object[])this.getPrimaryKeyColumns(), (Object)column);
    }

    @Override
    public Iterator<ForeignKey> foreignKeys() {
        return new ArrayIterator((Object[])this.getForeignKeys());
    }

    private synchronized DTPForeignKeyWrapper[] getForeignKeys() {
        if (this.foreignKeys == null) {
            this.foreignKeys = this.buildForeignKeys();
        }
        return this.foreignKeys;
    }

    private DTPForeignKeyWrapper[] buildForeignKeys() {
        if (!(this.dtpTable instanceof BaseTable)) {
            return EMPTY_FOREIGN_KEYS;
        }
        List<org.eclipse.datatools.modelbase.sql.constraints.ForeignKey> dtpForeignKeys = this.getDTPForeignKeys();
        DTPForeignKeyWrapper[] result = new DTPForeignKeyWrapper[dtpForeignKeys.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPForeignKeyWrapper(this, dtpForeignKeys.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.constraints.ForeignKey> getDTPForeignKeys() {
        return ((BaseTable)this.dtpTable).getForeignKeys();
    }

    @Override
    public int foreignKeysSize() {
        return this.getForeignKeys().length;
    }

    boolean foreignKeyBaseColumnsContains(Column column) {
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.getForeignKeys();
        int n = dTPForeignKeyWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper fkWrapper = dTPForeignKeyWrapperArray[n2];
            if (fkWrapper.baseColumnsContains(column)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isPossibleJoinTable() {
        if (this.getForeignKeys().length != 2) {
            return false;
        }
        DTPColumnWrapper[] dTPColumnWrapperArray = this.getColumns();
        int n = dTPColumnWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            if (!this.foreignKeyBaseColumnsContains(column)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public ForeignKey getJoinTableOwningForeignKey() {
        DTPForeignKeyWrapper fk0 = this.getForeignKeys()[0];
        String name0 = fk0.getReferencedTable().getName();
        DTPForeignKeyWrapper fk1 = this.getForeignKeys()[1];
        String name1 = fk1.getReferencedTable().getName();
        return this.getName().equals(String.valueOf(name1) + '_' + name0) ? fk1 : fk0;
    }

    @Override
    public ForeignKey getJoinTableNonOwningForeignKey() {
        DTPForeignKeyWrapper fk0 = this.getForeignKeys()[0];
        DTPForeignKeyWrapper fk1 = this.getForeignKeys()[1];
        ForeignKey ofk = this.getJoinTableOwningForeignKey();
        return ofk == fk0 ? fk1 : fk0;
    }

    @Override
    public boolean joinTableNameIsDefault() {
        return this.getName().equals(this.buildDefaultJoinTableName());
    }

    private String buildDefaultJoinTableName() {
        return String.valueOf(this.getJoinTableOwningTable().getName()) + '_' + this.getJoinTableNonOwningTable().getName();
    }

    private Table getJoinTableOwningTable() {
        return this.getJoinTableOwningForeignKey().getReferencedTable();
    }

    private Table getJoinTableNonOwningTable() {
        return this.getJoinTableNonOwningForeignKey().getReferencedTable();
    }

    @Override
    public int compareTo(Table table) {
        return Collator.getInstance().compare(this.getName(), table.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Table table) {
        return this.dtpTable == table;
    }

    DTPTableWrapper getTable(org.eclipse.datatools.modelbase.sql.tables.Table table) {
        return this.wraps(table) ? this : this.getSchema().getTable(table);
    }

    @Override
    synchronized void startListening() {
        if (this.foreignKeys != null) {
            this.startForeignKeys();
        }
        if (this.columns != null) {
            this.startColumns();
        }
        super.startListening();
    }

    private void startForeignKeys() {
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.foreignKeys;
        int n = this.foreignKeys.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper foreignKey = dTPForeignKeyWrapperArray[n2];
            foreignKey.startListening();
            ++n2;
        }
    }

    private void startColumns() {
        DTPColumnWrapper[] dTPColumnWrapperArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            column.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.foreignKeys != null) {
            this.stopForeignKeys();
        }
        if (this.columns != null) {
            this.stopColumns();
        }
        super.stopListening();
    }

    private void stopForeignKeys() {
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.foreignKeys;
        int n = this.foreignKeys.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper foreignKey = dTPForeignKeyWrapperArray[n2];
            foreignKey.stopListening();
            ++n2;
        }
    }

    private void stopColumns() {
        DTPColumnWrapper[] dTPColumnWrapperArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            column.stopListening();
            ++n2;
        }
    }

    @Override
    void clear() {
        if (this.foreignKeys != null) {
            this.clearForeignKeys();
        }
        this.primaryKeyColumns = null;
        if (this.columns != null) {
            this.clearColumns();
        }
    }

    private void clearForeignKeys() {
        this.stopForeignKeys();
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.foreignKeys;
        int n = this.foreignKeys.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper foreignKey = dTPForeignKeyWrapperArray[n2];
            foreignKey.clear();
            ++n2;
        }
        this.foreignKeys = null;
    }

    private void clearColumns() {
        this.stopColumns();
        DTPColumnWrapper[] dTPColumnWrapperArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            column.clear();
            ++n2;
        }
        this.columns = null;
    }
}

