/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.customization;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Profiler;
import org.eclipse.jpt.eclipselink.ui.JptEclipseLinkUiPlugin;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilerComposite
extends Pane<Customization> {
    public ProfilerComposite(Pane<? extends Customization> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private PropertyValueModel<String> buildDefaultProfilerHolder() {
        return new PropertyAspectAdapter<Customization, String>(this.getSubjectHolder(), new String[]{Customization.DEFAULT_PROFILER}){

            protected String buildValue_() {
                return ProfilerComposite.this.getDefaultValue((Customization)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultProfilerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultProfilerHolder());
    }

    private String buildDisplayString(String profilerName) {
        switch (Profiler.valueOf((String)profilerName)) {
            case no_profiler: {
                return EclipseLinkUiMessages.ProfilerComposite_no_profiler;
            }
            case performance_profiler: {
                return EclipseLinkUiMessages.ProfilerComposite_performance_profiler;
            }
            case query_monitor: {
                return EclipseLinkUiMessages.ProfilerComposite_query_monitor;
            }
        }
        return null;
    }

    private Comparator<String> buildProfilerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String profiler1, String profiler2) {
                profiler1 = ProfilerComposite.this.buildDisplayString(profiler1);
                profiler2 = ProfilerComposite.this.buildDisplayString(profiler2);
                return Collator.getInstance().compare(profiler1, profiler2);
            }
        };
    }

    private StringConverter<String> buildProfilerConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                try {
                    Profiler.valueOf((String)value);
                    value = ProfilerComposite.this.buildDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    private WritablePropertyValueModel<String> buildProfilerHolder() {
        return new PropertyAspectAdapter<Customization, String>(this.getSubjectHolder(), new String[]{"profilerProperty"}){

            protected String buildValue_() {
                String name = ((Customization)this.subject).getProfiler();
                if (name == null) {
                    name = ProfilerComposite.this.getDefaultValue((Customization)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (ProfilerComposite.this.getDefaultValue((Customization)this.subject).equals(value)) {
                    value = null;
                }
                ((Customization)this.subject).setProfiler(value);
            }
        };
    }

    private ListValueModel<String> buildProfilerListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultProfilerListHolder());
        holders.add(this.buildProfilersListHolder());
        return new CompositeListValueModel(holders);
    }

    private Iterator<String> buildProfilers() {
        return new TransformationIterator<Profiler, String>(CollectionTools.iterator((Object[])Profiler.values())){

            protected String transform(Profiler next) {
                return next.name();
            }
        };
    }

    private CollectionValueModel<String> buildProfilersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildProfilers()));
    }

    private ListValueModel<String> buildProfilersListHolder() {
        return new SortedListValueModelAdapter(this.buildProfilersCollectionHolder(), this.buildProfilerComparator());
    }

    private String getDefaultValue(Customization subject) {
        String defaultValue = subject.getDefaultProfiler();
        if (defaultValue != null) {
            return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlCustomizationTab_defaultWithOneParam, (Object)defaultValue);
        }
        return EclipseLinkUiMessages.PersistenceXmlCustomizationTab_defaultEmpty;
    }

    protected void initializeLayout(Composite container) {
        CCombo combo = this.addProfilerCCombo(container);
        this.addLabeledComposite(container, this.addLeftControl(container), (Control)combo.getParent(), (Control)this.addBrowseButton(container), null);
    }

    protected CCombo addProfilerCCombo(Composite container) {
        return this.addEditableCCombo(container, this.buildProfilerListHolder(), this.buildProfilerHolder(), this.buildProfilerConverter());
    }

    protected Control addLeftControl(Composite container) {
        return this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlCustomizationTab_profilerLabel);
    }

    protected Button addBrowseButton(Composite parent) {
        return this.addPushButton(parent, EclipseLinkUiMessages.PersistenceXmlCustomizationTab_browse, this.buildBrowseAction());
    }

    private Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                ProfilerComposite.this.promptType();
            }
        };
    }

    protected void promptType() {
        IType type = this.chooseType();
        if (type != null) {
            String className = type.getFullyQualifiedName('.');
            ((Customization)this.getSubject()).setProfiler(className);
        }
    }

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(this.getClassName() != null ? ClassTools.shortNameForClassNamed((String)this.getClassName()) : ""));
        }
        catch (JavaModelException e) {
            JptUiPlugin.log((Throwable)e);
            return null;
        }
        typeSelectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected String getClassName() {
        return ((Customization)this.getSubject()).getProfiler();
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        IProject project = ((Customization)this.getSubject()).getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
    }
}

