/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.caching;

import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCacheProperties
extends AbstractModel {
    private Caching caching;
    private String entityName;
    private PropertyValueModel<CacheType> cacheTypeHolder;
    private PropertyChangeListener cacheTypeListener;
    private PropertyValueModel<Integer> cacheSizeHolder;
    private PropertyChangeListener cacheSizeListener;
    private PropertyValueModel<Boolean> sharedCacheHolder;
    private PropertyChangeListener sharedCacheListener;
    private static final long serialVersionUID = 1L;
    public static final String CACHE_TYPE_PROPERTY = "cacheTypeProperty";
    public static final String CACHE_SIZE_PROPERTY = "cacheSizeProperty";
    public static final String SHARED_CACHE_PROPERTY = "sharedCacheProperty";

    public EntityCacheProperties(Caching caching, String entityName) {
        this.caching = caching;
        this.entityName = entityName;
        SimplePropertyValueModel cachingHolder = new SimplePropertyValueModel((Object)this.caching);
        this.initialize((PropertyValueModel<Caching>)cachingHolder);
    }

    protected void initialize(PropertyValueModel<Caching> cachingHolder) {
        this.cacheTypeHolder = this.buildCacheTypeAA(cachingHolder);
        this.cacheTypeListener = this.buildCacheTypeChangeListener();
        this.cacheTypeHolder.addPropertyChangeListener("value", this.cacheTypeListener);
        this.cacheSizeHolder = this.buildCacheSizeAA(cachingHolder);
        this.cacheSizeListener = this.buildCacheSizeChangeListener();
        this.cacheSizeHolder.addPropertyChangeListener("value", this.cacheSizeListener);
        this.sharedCacheHolder = this.buildSharedCacheAA(cachingHolder);
        this.sharedCacheListener = this.buildSharedCacheChangeListener();
        this.sharedCacheHolder.addPropertyChangeListener("value", this.sharedCacheListener);
    }

    public boolean entityNameIsValid() {
        return !StringTools.stringIsEmpty((String)this.entityName);
    }

    public Integer getCacheSize() {
        return this.caching.getCacheSize(this.entityName);
    }

    public CacheType getCacheType() {
        return this.caching.getCacheType(this.entityName);
    }

    public Caching getCaching() {
        return this.caching;
    }

    public Integer getDefaultCacheSize() {
        return this.caching.getDefaultCacheSize();
    }

    public CacheType getDefaultCacheType() {
        return this.caching.getDefaultCacheType();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Boolean getSharedCache() {
        return this.caching.getSharedCache(this.entityName);
    }

    public Boolean getDefaultSharedCache() {
        return this.caching.getDefaultSharedCache();
    }

    public void setCacheSize(Integer cacheSize) {
        Integer oldCacheSize = this.getCacheSize();
        if (this.attributeValueHasChanged(oldCacheSize, cacheSize)) {
            this.caching.setCacheSize(cacheSize, this.entityName);
            this.firePropertyChanged(CACHE_SIZE_PROPERTY, oldCacheSize, cacheSize);
        }
    }

    public void setCacheType(CacheType cacheType) {
        CacheType oldCacheType = this.getCacheType();
        if (this.attributeValueHasChanged(oldCacheType, cacheType)) {
            this.caching.setCacheType(cacheType, this.entityName);
            this.firePropertyChanged(CACHE_TYPE_PROPERTY, oldCacheType, cacheType);
        }
    }

    public void setSharedCache(Boolean sharedCache) {
        Boolean oldSharedCache = this.getSharedCache();
        if (this.attributeValueHasChanged(oldSharedCache, sharedCache)) {
            this.caching.setSharedCache(sharedCache, this.entityName);
            this.firePropertyChanged(SHARED_CACHE_PROPERTY, oldSharedCache, sharedCache);
        }
    }

    private PropertyValueModel<CacheType> buildCacheTypeAA(PropertyValueModel<Caching> subjectHolder) {
        return new PropertyAspectAdapter<Caching, CacheType>(subjectHolder, new String[]{CACHE_TYPE_PROPERTY}){

            protected CacheType buildValue_() {
                return ((Caching)this.subject).getCacheType(EntityCacheProperties.this.entityName);
            }
        };
    }

    private PropertyChangeListener buildCacheTypeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                EntityCacheProperties.this.firePropertyChanged(EntityCacheProperties.CACHE_TYPE_PROPERTY, e.getOldValue(), e.getNewValue());
            }
        };
    }

    private PropertyValueModel<Integer> buildCacheSizeAA(PropertyValueModel<Caching> subjectHolder) {
        return new PropertyAspectAdapter<Caching, Integer>(subjectHolder, new String[]{CACHE_SIZE_PROPERTY}){

            protected Integer buildValue_() {
                return ((Caching)this.subject).getCacheSize(EntityCacheProperties.this.entityName);
            }
        };
    }

    private PropertyChangeListener buildCacheSizeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                EntityCacheProperties.this.firePropertyChanged(EntityCacheProperties.CACHE_SIZE_PROPERTY, e.getOldValue(), e.getNewValue());
            }
        };
    }

    private PropertyValueModel<Boolean> buildSharedCacheAA(PropertyValueModel<Caching> subjectHolder) {
        return new PropertyAspectAdapter<Caching, Boolean>(subjectHolder, new String[]{SHARED_CACHE_PROPERTY}){

            protected Boolean buildValue_() {
                return ((Caching)this.subject).getSharedCache(EntityCacheProperties.this.entityName);
            }
        };
    }

    private PropertyChangeListener buildSharedCacheChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                EntityCacheProperties.this.firePropertyChanged(EntityCacheProperties.SHARED_CACHE_PROPERTY, e.getOldValue(), e.getNewValue());
            }
        };
    }

    public void toString(StringBuilder sb) {
        sb.append("name: ");
        sb.append(this.entityName);
        sb.append(", type: ");
        sb.append(this.getCacheType());
        sb.append(", size: ");
        sb.append(this.getCacheSize());
        sb.append(", isShared: ");
        sb.append(this.getSharedCache());
    }
}

