/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable
extends AbstractJavaJpaContextNode
implements Table,
UniqueConstraint.Owner {
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final List<JavaUniqueConstraint> uniqueConstraints = new ArrayList<JavaUniqueConstraint>();

    protected AbstractJavaTable(JavaJpaContextNode parent) {
        super(parent);
    }

    protected abstract TableAnnotation getResourceTable();

    protected abstract String getAnnotationName();

    protected abstract String buildDefaultName();

    protected abstract String buildDefaultSchema();

    protected abstract String buildDefaultCatalog();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.getResourceTable().setName(name);
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.getResourceTable().setSchema(schema);
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected void setSpecifiedSchema_(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.firePropertyChanged("specifiedSchema", oldSpecifiedSchema, newSpecifiedSchema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.getResourceTable().setCatalog(catalog);
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    public ListIterator<JavaUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint(int index) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        this.uniqueConstraints.add(index, uniqueConstraint);
        UniqueConstraintAnnotation uniqueConstraintAnnotation = this.getResourceTable().addUniqueConstraint(index);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        this.fireItemAdded("uniqueConstraints", index, uniqueConstraint);
        return uniqueConstraint;
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        JavaUniqueConstraint removedUniqueConstraint = this.uniqueConstraints.remove(index);
        this.getResourceTable().removeUniqueConstraint(index);
        this.fireItemRemoved("uniqueConstraints", index, removedUniqueConstraint);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().moveUniqueConstraint(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    protected void addUniqueConstraint(int index, JavaUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected void addUniqueConstraint(JavaUniqueConstraint uniqueConstraint) {
        this.addUniqueConstraint(this.uniqueConstraints.size(), uniqueConstraint);
    }

    protected void removeUniqueConstraint_(JavaUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected TextRange getTextRange(TextRange textRange, CompilationUnit astRoot) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getResourceTable().getNameTextRange(astRoot), astRoot);
    }

    protected boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceTable().nameTouches(pos, astRoot);
    }

    protected TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getResourceTable().getSchemaTextRange(astRoot), astRoot);
    }

    protected boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceTable().schemaTouches(pos, astRoot);
    }

    protected TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getResourceTable().getCatalogTextRange(astRoot), astRoot);
    }

    protected boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceTable().catalogTouches(pos, astRoot);
    }

    protected void initialize(TableAnnotation tableAnnotation) {
        this.defaultName = this.buildDefaultName();
        this.specifiedName = tableAnnotation.getName();
        this.defaultSchema = this.buildDefaultSchema();
        this.specifiedSchema = tableAnnotation.getSchema();
        this.defaultCatalog = this.buildDefaultCatalog();
        this.specifiedCatalog = tableAnnotation.getCatalog();
        this.initializeUniqueConstraints(tableAnnotation);
    }

    protected void initializeUniqueConstraints(TableAnnotation tableAnnotation) {
        for (UniqueConstraintAnnotation uniqueConstraintAnnotation : CollectionTools.iterable(tableAnnotation.uniqueConstraints())) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(uniqueConstraintAnnotation));
        }
    }

    protected void update(TableAnnotation tableAnnotation) {
        this.setDefaultName(this.buildDefaultName());
        this.setSpecifiedName_(tableAnnotation.getName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setSpecifiedSchema_(tableAnnotation.getSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setSpecifiedCatalog_(tableAnnotation.getCatalog());
        this.updateUniqueConstraints(tableAnnotation);
    }

    protected void updateUniqueConstraints(TableAnnotation tableAnnotation) {
        ListIterator<UniqueConstraintAnnotation> resourceConstraints = tableAnnotation.uniqueConstraints();
        ListIterator<JavaUniqueConstraint> contextConstraints = this.uniqueConstraints();
        while (contextConstraints.hasNext()) {
            JavaUniqueConstraint uniqueConstraint = contextConstraints.next();
            if (resourceConstraints.hasNext()) {
                uniqueConstraint.update(resourceConstraints.next());
                continue;
            }
            this.removeUniqueConstraint_(uniqueConstraint);
        }
        while (resourceConstraints.hasNext()) {
            this.addUniqueConstraint(this.buildUniqueConstraint(resourceConstraints.next()));
        }
    }

    protected JavaUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        return uniqueConstraint;
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return this.getDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean hasResolvedCatalog() {
        String catalog = this.getCatalog();
        if (catalog == null) {
            return true;
        }
        return this.getDbCatalog(catalog) != null;
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        org.eclipse.jpt.db.Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.sortedColumnIdentifiers() : EmptyIterator.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.getResourceTable().getTextRange(astRoot), astRoot);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaUniqueConstraint constraint : CollectionTools.iterable(this.uniqueConstraints())) {
            result = constraint.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.javaCandidateNames(filter);
        }
        if (this.schemaTouches(pos, astRoot)) {
            return this.javaCandidateSchemata(filter);
        }
        if (this.catalogTouches(pos, astRoot)) {
            return this.javaCandidateCatalogs(filter);
        }
        return null;
    }

    protected Iterator<String> javaCandidateNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateNames(filter));
    }

    protected Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    protected Iterator<String> candidateNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.sortedTableIdentifiers() : EmptyIterator.instance();
    }

    protected Iterator<String> javaCandidateSchemata(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateSchemata(filter));
    }

    protected Iterator<String> candidateSchemata(Filter<String> filter) {
        return new FilteringIterator(this.candidateSchemata(), filter);
    }

    protected Iterator<String> candidateSchemata() {
        return this.getDbSchemaContainer().sortedSchemaIdentifiers();
    }

    protected Iterator<String> javaCandidateCatalogs(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateCatalogs(filter));
    }

    protected Iterator<String> candidateCatalogs(Filter<String> filter) {
        return new FilteringIterator(this.candidateCatalogs(), filter);
    }

    protected Iterator<String> candidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.sortedCatalogIdentifiers() : EmptyIterator.instance();
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getQualifiedName());
    }

    protected String getQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }
}

