/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaNamedColumn;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaDiscriminatorColumn
extends AbstractJavaNamedColumn<DiscriminatorColumnAnnotation>
implements JavaDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType;
    protected Integer specifiedLength;
    protected JavaResourcePersistentMember persistenceResource;

    public GenericJavaDiscriminatorColumn(JavaEntity parent, JavaNamedColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(JavaResourcePersistentMember persistentResource) {
        this.persistenceResource = persistentResource;
        this.initialize(this.getResourceColumn());
    }

    @Override
    public void initialize(DiscriminatorColumnAnnotation column) {
        super.initialize(column);
        this.specifiedDiscriminatorType = this.discriminatorType(column);
        this.specifiedLength = this.length(column);
    }

    protected JavaEntity getJavaEntity() {
        return (JavaEntity)super.getParent();
    }

    @Override
    protected DiscriminatorColumnAnnotation getResourceColumn() {
        return (DiscriminatorColumnAnnotation)this.persistenceResource.getNonNullSupportingAnnotation("javax.persistence.DiscriminatorColumn");
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.getSpecifiedDiscriminatorType() == null ? this.getDefaultDiscriminatorType() : this.getSpecifiedDiscriminatorType();
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE;
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        this.getResourceColumn().setDiscriminatorType(DiscriminatorType.toJavaResourceModel(newSpecifiedDiscriminatorType));
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    @Override
    public Integer getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength();
    }

    @Override
    public Integer getDefaultLength() {
        return DiscriminatorColumn.DEFAULT_LENGTH;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.getResourceColumn().setLength(newSpecifiedLength);
        this.firePropertyChanged("spcifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("spcifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    protected String getTableName() {
        return this.getJavaEntity().getPrimaryTableName();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceColumn().getTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    public void update(JavaResourcePersistentMember persistentResource) {
        this.persistenceResource = persistentResource;
        this.update(this.getResourceColumn());
    }

    @Override
    public void update(DiscriminatorColumnAnnotation discriminatorColumn) {
        super.update(discriminatorColumn);
        this.setSpecifiedDiscriminatorType_(this.discriminatorType(discriminatorColumn));
        this.setSpecifiedLength_(this.length(discriminatorColumn));
    }

    protected DiscriminatorType discriminatorType(DiscriminatorColumnAnnotation discriminatorColumn) {
        return DiscriminatorType.fromJavaResourceModel(discriminatorColumn.getDiscriminatorType());
    }

    protected Integer length(DiscriminatorColumnAnnotation discriminatorColumn) {
        return discriminatorColumn.getLength();
    }
}

