/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmConverter;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmNullConverter;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmTemporalConverter;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValueImpl;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.orm.XmlIdImpl;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGeneratorImpl;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGeneratorImpl;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmIdMapping
extends AbstractOrmAttributeMapping<XmlId>
implements OrmIdMapping {
    protected final OrmColumn column = this.getJpaFactory().buildOrmColumn(this, this);
    protected OrmGeneratedValue generatedValue;
    protected OrmConverter defaultConverter;
    protected OrmConverter specifiedConverter;
    protected OrmTableGenerator tableGenerator;
    protected OrmSequenceGenerator sequenceGenerator;

    public GenericOrmIdMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public int getXmlSequence() {
        return 0;
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmIdMapping(this);
    }

    @Override
    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public OrmConverter getConverter() {
        return this.getSpecifiedConverter() == null ? this.getDefaultConverter() : this.getSpecifiedConverter();
    }

    @Override
    public OrmConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    public OrmConverter getSpecifiedConverter() {
        return this.specifiedConverter;
    }

    protected String getSpecifedConverterType() {
        if (this.specifiedConverter == null) {
            return "noConverter";
        }
        return this.specifiedConverter.getType();
    }

    @Override
    public void setSpecifiedConverter(String converterType) {
        if (this.getSpecifedConverterType() == converterType) {
            return;
        }
        OrmConverter oldConverter = this.specifiedConverter;
        OrmConverter newConverter = this.buildSpecifiedConverter(converterType);
        this.specifiedConverter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.specifiedConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    protected void setSpecifiedConverter(OrmConverter newConverter) {
        OrmConverter oldConverter = this.specifiedConverter;
        this.specifiedConverter = newConverter;
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    @Override
    public OrmGeneratedValue addGeneratedValue() {
        if (this.getGeneratedValue() != null) {
            throw new IllegalStateException("gemeratedValue already exists");
        }
        XmlGeneratedValueImpl resourceGeneratedValue = OrmFactory.eINSTANCE.createXmlGeneratedValueImpl();
        this.generatedValue = this.buildGeneratedValue(resourceGeneratedValue);
        ((XmlId)this.resourceAttributeMapping).setGeneratedValue(resourceGeneratedValue);
        this.firePropertyChanged("generatedValueProperty", null, this.generatedValue);
        return this.generatedValue;
    }

    @Override
    public void removeGeneratedValue() {
        if (this.getGeneratedValue() == null) {
            throw new IllegalStateException("gemeratedValue does not exist, cannot be removed");
        }
        OrmGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = null;
        ((XmlId)this.resourceAttributeMapping).setGeneratedValue(null);
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, null);
    }

    @Override
    public OrmGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    protected void setGeneratedValue(OrmGeneratedValue newGeneratedValue) {
        OrmGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = newGeneratedValue;
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, newGeneratedValue);
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        XmlSequenceGeneratorImpl resourceSequenceGenerator = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        this.sequenceGenerator = this.buildSequenceGenerator(resourceSequenceGenerator);
        ((XmlId)this.resourceAttributeMapping).setSequenceGenerator(resourceSequenceGenerator);
        this.firePropertyChanged("sequenceGenerator", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        ((XmlId)this.resourceAttributeMapping).setSequenceGenerator(null);
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, null);
    }

    @Override
    public OrmSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(OrmSequenceGenerator newSequenceGenerator) {
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        XmlTableGeneratorImpl resourceTableGenerator = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        this.tableGenerator = this.buildTableGenerator(resourceTableGenerator);
        ((XmlId)this.resourceAttributeMapping).setTableGenerator(resourceTableGenerator);
        this.firePropertyChanged("tableGenerator", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        ((XmlId)this.resourceAttributeMapping).setTableGenerator(null);
        this.firePropertyChanged("tableGenerator", oldTableGenerator, null);
    }

    @Override
    public OrmTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(OrmTableGenerator newTableGenerator) {
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGenerator", oldTableGenerator, newTableGenerator);
    }

    protected Iterator<OrmGenerator> generators() {
        ArrayList<OrmGenerator> generators = new ArrayList<OrmGenerator>();
        this.addGeneratorsTo(generators);
        return generators.iterator();
    }

    protected void addGeneratorsTo(ArrayList<OrmGenerator> generators) {
        if (this.sequenceGenerator != null) {
            generators.add(this.sequenceGenerator);
        }
        if (this.tableGenerator != null) {
            generators.add(this.tableGenerator);
        }
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getColumn().getName();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public boolean isIdMapping() {
        return true;
    }

    @Override
    public XmlId addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlIdImpl id = OrmFactory.eINSTANCE.createXmlIdImpl();
        this.getPersistentAttribute().initialize(id);
        typeMapping.getAttributes().getIds().add((Object)id);
        return id;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getIds().remove((Object)this.resourceAttributeMapping);
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public void initialize(XmlAttributeMapping attributeMapping) {
        super.initialize(attributeMapping);
        this.column.initialize(((XmlId)this.resourceAttributeMapping).getColumn());
        this.initializeSequenceGenerator();
        this.initializeTableGenerator();
        this.initializeGeneratedValue();
        this.defaultConverter = new GenericOrmNullConverter(this);
        this.specifiedConverter = this.buildSpecifiedConverter(this.specifiedConverterType());
    }

    protected void initializeSequenceGenerator() {
        if (((XmlId)this.resourceAttributeMapping).getSequenceGenerator() != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(((XmlId)this.resourceAttributeMapping).getSequenceGenerator());
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator resourceSequenceGenerator) {
        return this.getJpaFactory().buildOrmSequenceGenerator(this, resourceSequenceGenerator);
    }

    protected void initializeTableGenerator() {
        if (((XmlId)this.resourceAttributeMapping).getTableGenerator() != null) {
            this.tableGenerator = this.buildTableGenerator(((XmlId)this.resourceAttributeMapping).getTableGenerator());
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator resourceTableGenerator) {
        return this.getJpaFactory().buildOrmTableGenerator(this, resourceTableGenerator);
    }

    protected void initializeGeneratedValue() {
        if (((XmlId)this.resourceAttributeMapping).getGeneratedValue() != null) {
            this.generatedValue = this.buildGeneratedValue(((XmlId)this.resourceAttributeMapping).getGeneratedValue());
        }
    }

    protected OrmGeneratedValue buildGeneratedValue(XmlGeneratedValue resourceGeneratedValue) {
        return this.getJpaFactory().buildOrmGeneratedValue(this, resourceGeneratedValue);
    }

    @Override
    public void update() {
        super.update();
        this.column.update(((XmlId)this.resourceAttributeMapping).getColumn());
        this.updateSequenceGenerator();
        this.updateTableGenerator();
        this.updateGeneratedValue();
        if (this.specifiedConverterType() == this.getSpecifedConverterType()) {
            this.getSpecifiedConverter().update();
        } else {
            this.setSpecifiedConverter(this.buildSpecifiedConverter(this.specifiedConverterType()));
        }
    }

    protected void updateSequenceGenerator() {
        if (((XmlId)this.resourceAttributeMapping).getSequenceGenerator() == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(((XmlId)this.resourceAttributeMapping).getSequenceGenerator()));
        } else {
            this.getSequenceGenerator().update(((XmlId)this.resourceAttributeMapping).getSequenceGenerator());
        }
    }

    protected void updateTableGenerator() {
        if (((XmlId)this.resourceAttributeMapping).getTableGenerator() == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(((XmlId)this.resourceAttributeMapping).getTableGenerator()));
        } else {
            this.getTableGenerator().update(((XmlId)this.resourceAttributeMapping).getTableGenerator());
        }
    }

    protected void updateGeneratedValue() {
        if (((XmlId)this.resourceAttributeMapping).getGeneratedValue() == null) {
            if (this.getGeneratedValue() != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.getGeneratedValue() == null) {
            this.setGeneratedValue(this.buildGeneratedValue(((XmlId)this.resourceAttributeMapping).getGeneratedValue()));
        } else {
            this.getGeneratedValue().update(((XmlId)this.resourceAttributeMapping).getGeneratedValue());
        }
    }

    protected OrmConverter buildSpecifiedConverter(String converterType) {
        if (converterType == "temporalConverter") {
            return new GenericOrmTemporalConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        return null;
    }

    protected String specifiedConverterType() {
        if (((XmlId)this.resourceAttributeMapping).getTemporal() != null) {
            return "temporalConverter";
        }
        return null;
    }

    @Override
    public XmlColumn getResourceColumn() {
        return ((XmlId)this.resourceAttributeMapping).getColumn();
    }

    @Override
    public void addResourceColumn() {
        ((XmlId)this.resourceAttributeMapping).setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeResourceColumn() {
        ((XmlId)this.resourceAttributeMapping).setColumn(null);
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.connectionProfileIsActive() && this.ownerIsEntity()) {
            this.validateColumn(messages);
        }
        this.validateGeneratedValue(messages);
        this.validateGenerators(messages);
    }

    protected void validateColumn(List<IMessage> messages) {
        PersistentAttribute pa = this.getPersistentAttribute();
        String tableName = this.column.getTable();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            if (pa.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{pa.getName(), tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            }
            return;
        }
        if (!this.column.isResolved()) {
            if (pa.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{pa.getName(), this.column.getName()}, this.column, this.column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange()));
            }
        }
    }

    protected void validateGeneratedValue(List<IMessage> messages) {
        if (this.generatedValue == null) {
            return;
        }
        String generatorName = this.generatedValue.getGenerator();
        if (generatorName == null) {
            return;
        }
        ListIterator<Generator> stream = this.getPersistenceUnit().allGenerators();
        while (stream.hasNext()) {
            if (!generatorName.equals(((Generator)stream.next()).getName())) continue;
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME", new String[]{generatorName}, this, this.generatedValue.getGeneratorTextRange()));
    }

    protected void validateGenerators(List<IMessage> messages) {
        Iterator<OrmGenerator> localGenerators = this.generators();
        while (localGenerators.hasNext()) {
            OrmGenerator localGenerator = localGenerators.next();
            if (localGenerator.isVirtual()) continue;
            ListIterator<Generator> globalGenerators = this.getPersistenceUnit().allGenerators();
            while (globalGenerators.hasNext()) {
                if (!localGenerator.duplicates((Generator)globalGenerators.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{localGenerator.getName()}, localGenerator, localGenerator.getNameTextRange()));
            }
        }
    }
}

