/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.resource.java.JoinColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.OverrideImpl;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAssociationOverride;
import org.eclipse.jpt.core.resource.java.NestableJoinColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationOverrideImpl
extends OverrideImpl
implements NestableAssociationOverride {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AssociationOverride");
    protected final List<NestableJoinColumn> joinColumns = new ArrayList<NestableJoinColumn>();
    private final JoinColumnsContainerAnnotation joinColumnsContainerAnnotation = new JoinColumnsContainerAnnotation();

    protected AssociationOverrideImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this.joinColumnsContainerAnnotation);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AssociationOverride";
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        AssociationOverrideAnnotation oldAssociationOverride = (AssociationOverrideAnnotation)((Object)oldAnnotation);
        for (JoinColumnAnnotation joinColumn : CollectionTools.iterable(oldAssociationOverride.joinColumns())) {
            NestableJoinColumn newJoinColumn = this.addJoinColumn(oldAssociationOverride.indexOfJoinColumn(joinColumn));
            newJoinColumn.initializeFrom((NestableAnnotation)((Object)joinColumn));
        }
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumn joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumn addJoinColumn(int index) {
        NestableJoinColumn joinColumn = (NestableJoinColumn)ContainerAnnotationTools.addNestedAnnotation(index, this.joinColumnsContainerAnnotation);
        this.fireItemAdded("joinColumnsList", index, joinColumn);
        return joinColumn;
    }

    protected void addJoinColumn(int index, NestableJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.joinColumns, "joinColumnsList");
    }

    @Override
    public void removeJoinColumn(int index) {
        NestableJoinColumn joinColumn = this.joinColumns.get(index);
        this.removeJoinColumn(joinColumn);
        joinColumn.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, this.joinColumnsContainerAnnotation);
    }

    protected void removeJoinColumn(NestableJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.joinColumns, "joinColumnsList");
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        this.moveJoinColumnInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, this.joinColumnsContainerAnnotation);
        this.fireItemMoved("joinColumnsList", targetIndex, sourceIndex);
    }

    protected void moveJoinColumnInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex);
    }

    protected NestableJoinColumn createJoinColumn(int index) {
        return JoinColumnImpl.createAssociationOverrideJoinColumn(this.getDeclarationAnnotationAdapter(), this, this.getMember(), index);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.updateJoinColumnsFromJava(astRoot);
    }

    private void updateJoinColumnsFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this.joinColumnsContainerAnnotation);
    }

    static AssociationOverrideImpl createAssociationOverride(JavaResourceNode parent, Member member) {
        return new AssociationOverrideImpl(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static AssociationOverrideImpl createNestedAssociationOverride(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = AssociationOverrideImpl.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new AssociationOverrideImpl(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(attributeOverridesAdapter, index, "javax.persistence.AssociationOverride");
    }

    public static class AssociationOverrideAnnotationDefinition
    implements AnnotationDefinition {
        private static final AssociationOverrideAnnotationDefinition INSTANCE = new AssociationOverrideAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private AssociationOverrideAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return AssociationOverrideImpl.createAssociationOverride(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.AssociationOverride";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnsContainerAnnotation
    extends AbstractJavaResourceNode
    implements ContainerAnnotation<NestableJoinColumn> {
        public JoinColumnsContainerAnnotation() {
            super(AssociationOverrideImpl.this);
        }

        @Override
        public void initialize(CompilationUnit astRoot) {
        }

        @Override
        public NestableJoinColumn addInternal(int index) {
            NestableJoinColumn joinColumn = AssociationOverrideImpl.this.createJoinColumn(index);
            AssociationOverrideImpl.this.joinColumns.add(index, joinColumn);
            return joinColumn;
        }

        @Override
        public NestableJoinColumn add(int index) {
            NestableJoinColumn joinColumn = AssociationOverrideImpl.this.createJoinColumn(index);
            AssociationOverrideImpl.this.addJoinColumn(index, joinColumn);
            return joinColumn;
        }

        @Override
        public int indexOf(NestableJoinColumn pkJoinColumn) {
            return AssociationOverrideImpl.this.indexOfJoinColumn(pkJoinColumn);
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            AssociationOverrideImpl.this.moveJoinColumn(targetIndex, sourceIndex);
        }

        @Override
        public void moveInternal(int targetIndex, int sourceIndex) {
            AssociationOverrideImpl.this.moveJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumn nestedAnnotationAt(int index) {
            return AssociationOverrideImpl.this.joinColumnAt(index);
        }

        @Override
        public ListIterator<NestableJoinColumn> nestedAnnotations() {
            return new CloneListIterator(AssociationOverrideImpl.this.joinColumns);
        }

        @Override
        public int nestedAnnotationsSize() {
            return AssociationOverrideImpl.this.joinColumnsSize();
        }

        @Override
        public void remove(int index) {
            this.remove(this.nestedAnnotationAt(index));
        }

        @Override
        public void remove(NestableJoinColumn joinColumn) {
            AssociationOverrideImpl.this.removeJoinColumn(joinColumn);
        }

        @Override
        public String getAnnotationName() {
            return AssociationOverrideImpl.this.getAnnotationName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        @Override
        public NestableJoinColumn nestedAnnotationFor(org.eclipse.jdt.core.dom.Annotation jdtAnnotation) {
            for (NestableJoinColumn pkJoinColumn : CollectionTools.iterable(this.nestedAnnotations())) {
                if (jdtAnnotation != pkJoinColumn.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
                return pkJoinColumn;
            }
            return null;
        }

        @Override
        public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
            return AssociationOverrideImpl.this.getJdtAnnotation(astRoot);
        }

        @Override
        public void newAnnotation() {
            AssociationOverrideImpl.this.newAnnotation();
        }

        @Override
        public void removeAnnotation() {
            AssociationOverrideImpl.this.removeAnnotation();
        }

        @Override
        public void update(CompilationUnit astRoot) {
            AssociationOverrideImpl.this.update(astRoot);
        }

        @Override
        public TextRange getTextRange(CompilationUnit astRoot) {
            return AssociationOverrideImpl.this.getTextRange(astRoot);
        }

        @Override
        public String getElementName() {
            return "joinColumns";
        }

        public void toString(StringBuilder sb) {
            sb.append(this.getAnnotationName());
        }
    }
}

