/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.java;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenerationType {
    TABLE,
    SEQUENCE,
    IDENTITY,
    AUTO;


    public static GenerationType fromJavaAnnotationValue(Object javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            return null;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.TABLE")) {
            return TABLE;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.SEQUENCE")) {
            return SEQUENCE;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.IDENTITY")) {
            return IDENTITY;
        }
        if (javaAnnotationValue.equals("javax.persistence.GenerationType.AUTO")) {
            return AUTO;
        }
        return null;
    }

    public static String toJavaAnnotationValue(GenerationType generationType) {
        if (generationType == null) {
            return null;
        }
        switch (generationType) {
            case TABLE: {
                return "javax.persistence.GenerationType.TABLE";
            }
            case SEQUENCE: {
                return "javax.persistence.GenerationType.SEQUENCE";
            }
            case IDENTITY: {
                return "javax.persistence.GenerationType.IDENTITY";
            }
            case AUTO: {
                return "javax.persistence.GenerationType.AUTO";
            }
        }
        throw new IllegalArgumentException("unknown generation type: " + (Object)((Object)generationType));
    }
}

