/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.internal.JavaJpaFile;
import org.eclipse.jpt.core.internal.XmlJpaFile;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JpaUiFactory;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultAttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.details.TypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.DefaultBasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.DefaultEmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaBasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaDetailsProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaEmbeddableUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaEmbeddedIdMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaEmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaEntityUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaIdMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaManyToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaManyToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaMappedSuperclassUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaOneToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaOneToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaTransientMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaVersionMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.NullAttributeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.NullTypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmBasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmDetailsProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmEmbeddableUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmEmbeddedIdMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmEmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmEntityUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmIdMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmManyToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmManyToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmMappedSuperclassUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmOneToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmOneToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmTransientMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmVersionMappingUiProvider;
import org.eclipse.jpt.ui.internal.platform.base.EntitiesGenerator;
import org.eclipse.jpt.ui.internal.structure.JavaResourceModelStructureProvider;
import org.eclipse.jpt.ui.internal.structure.OrmResourceModelStructureProvider;
import org.eclipse.jpt.ui.internal.structure.PersistenceResourceModelStructureProvider;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatformUi
implements JpaPlatformUi {
    private List<JpaDetailsProvider> detailsProviders;
    private List<TypeMappingUiProvider<? extends TypeMapping>> javaTypeMappingUiProviders;
    private List<AttributeMappingUiProvider<? extends AttributeMapping>> javaAttributeMappingUiProviders;
    private List<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultJavaAttributeMappingUiProviders;
    private List<TypeMappingUiProvider<? extends TypeMapping>> ormTypeMappingUiProviders;
    private List<AttributeMappingUiProvider<? extends AttributeMapping>> ormAttributeMappingUiProviders;
    private List<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultOrmAttributeMappingUiProviders;
    private JpaUiFactory jpaUiFactory = this.createJpaUiFactory();

    protected BaseJpaPlatformUi() {
    }

    @Override
    public JpaStructureProvider buildStructureProvider(JpaFile jpaFile) {
        String resourceType = jpaFile.getResourceType();
        if (resourceType == "JAVA_RESOURCE_TYPE") {
            return new JavaResourceModelStructureProvider((JavaJpaFile)jpaFile);
        }
        if (resourceType == "ORM_RESOURCE_TYPE") {
            return new OrmResourceModelStructureProvider((XmlJpaFile)jpaFile);
        }
        if (resourceType == "PERSISTENCE_RESOURCE_TYPE") {
            return new PersistenceResourceModelStructureProvider((XmlJpaFile)jpaFile);
        }
        return null;
    }

    protected abstract JpaUiFactory createJpaUiFactory();

    @Override
    public JpaUiFactory getJpaUiFactory() {
        return this.jpaUiFactory;
    }

    protected List<JpaDetailsProvider> getDetailsProviders() {
        if (this.detailsProviders == null) {
            this.detailsProviders = new ArrayList<JpaDetailsProvider>();
            this.addDetailsProvidersTo(this.detailsProviders);
        }
        return Collections.unmodifiableList(this.detailsProviders);
    }

    public Iterator<JpaDetailsProvider> detailsProviders() {
        return this.getDetailsProviders().iterator();
    }

    protected void addDetailsProvidersTo(Collection<JpaDetailsProvider> providers) {
        providers.add(new JavaDetailsProvider());
        providers.add(new OrmDetailsProvider());
    }

    @Override
    public JpaDetailsProvider getDetailsProvider(JpaStructureNode structureNode) {
        if (structureNode instanceof JavaJpaContextNode) {
            return this.getDetailsProviders().get(0);
        }
        return this.getDetailsProviders().get(1);
    }

    @Override
    public Iterator<TypeMappingUiProvider<? extends TypeMapping>> typeMappingUiProviders(PersistentType type) {
        if (type instanceof JavaPersistentType) {
            return this.javaTypeMappingUiProviders();
        }
        if (type instanceof OrmPersistentType) {
            return this.ormTypeMappingUiProviders();
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> attributeMappingUiProviders(PersistentAttribute attribute) {
        if (attribute instanceof JavaPersistentAttribute) {
            return this.javaAttributeMappingUiProviders();
        }
        if (attribute instanceof OrmPersistentAttribute) {
            return this.ormAttributeMappingUiProviders();
        }
        return EmptyIterator.instance();
    }

    public ListIterator<TypeMappingUiProvider<? extends TypeMapping>> javaTypeMappingUiProviders() {
        if (this.javaTypeMappingUiProviders == null) {
            this.javaTypeMappingUiProviders = new ArrayList<TypeMappingUiProvider<? extends TypeMapping>>();
            this.addJavaTypeMappingUiProvidersTo(this.javaTypeMappingUiProviders);
        }
        return new CloneListIterator(this.javaTypeMappingUiProviders);
    }

    protected void addJavaTypeMappingUiProvidersTo(List<TypeMappingUiProvider<? extends TypeMapping>> providers) {
        providers.add(NullTypeMappingUiProvider.instance());
        providers.add(JavaEntityUiProvider.instance());
        providers.add(JavaMappedSuperclassUiProvider.instance());
        providers.add(JavaEmbeddableUiProvider.instance());
    }

    public ListIterator<AttributeMappingUiProvider<? extends AttributeMapping>> javaAttributeMappingUiProviders() {
        if (this.javaAttributeMappingUiProviders == null) {
            this.javaAttributeMappingUiProviders = new ArrayList<AttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addJavaAttributeMappingUiProvidersTo(this.javaAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.javaAttributeMappingUiProviders);
    }

    protected void addJavaAttributeMappingUiProvidersTo(List<AttributeMappingUiProvider<? extends AttributeMapping>> providers) {
        providers.add(JavaIdMappingUiProvider.instance());
        providers.add(JavaEmbeddedIdMappingUiProvider.instance());
        providers.add(JavaBasicMappingUiProvider.instance());
        providers.add(JavaVersionMappingUiProvider.instance());
        providers.add(JavaManyToOneMappingUiProvider.instance());
        providers.add(JavaOneToManyMappingUiProvider.instance());
        providers.add(JavaOneToOneMappingUiProvider.instance());
        providers.add(JavaManyToManyMappingUiProvider.instance());
        providers.add(JavaEmbeddedMappingUiProvider.instance());
        providers.add(JavaTransientMappingUiProvider.instance());
        providers.add(NullAttributeMappingUiProvider.instance());
    }

    public ListIterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultJavaAttributeMappingUiProviders() {
        if (this.defaultJavaAttributeMappingUiProviders == null) {
            this.defaultJavaAttributeMappingUiProviders = new ArrayList<DefaultAttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addDefaultJavaAttributeMappingUiProvidersTo(this.defaultJavaAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.defaultJavaAttributeMappingUiProviders);
    }

    protected void addDefaultJavaAttributeMappingUiProvidersTo(List<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> providers) {
        providers.add(DefaultBasicMappingUiProvider.instance());
        providers.add(DefaultEmbeddedMappingUiProvider.instance());
    }

    @Override
    public void generateEntities(JpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }

    @Override
    public Iterator<TypeMappingUiProvider<? extends TypeMapping>> ormTypeMappingUiProviders() {
        if (this.ormTypeMappingUiProviders == null) {
            this.ormTypeMappingUiProviders = new ArrayList<TypeMappingUiProvider<? extends TypeMapping>>();
            this.addOrmTypeMappingUiProvidersTo(this.ormTypeMappingUiProviders);
        }
        return new CloneListIterator(this.ormTypeMappingUiProviders);
    }

    protected void addOrmTypeMappingUiProvidersTo(List<TypeMappingUiProvider<? extends TypeMapping>> providers) {
        providers.add(OrmEntityUiProvider.instance());
        providers.add(OrmMappedSuperclassUiProvider.instance());
        providers.add(OrmEmbeddableUiProvider.instance());
    }

    @Override
    public Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> ormAttributeMappingUiProviders() {
        if (this.ormAttributeMappingUiProviders == null) {
            this.ormAttributeMappingUiProviders = new ArrayList<AttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addOrmAttributeMappingUiProvidersTo(this.ormAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.ormAttributeMappingUiProviders);
    }

    protected void addOrmAttributeMappingUiProvidersTo(List<AttributeMappingUiProvider<? extends AttributeMapping>> providers) {
        providers.add(OrmIdMappingUiProvider.instance());
        providers.add(OrmEmbeddedIdMappingUiProvider.instance());
        providers.add(OrmBasicMappingUiProvider.instance());
        providers.add(OrmVersionMappingUiProvider.instance());
        providers.add(OrmManyToOneMappingUiProvider.instance());
        providers.add(OrmOneToManyMappingUiProvider.instance());
        providers.add(OrmOneToOneMappingUiProvider.instance());
        providers.add(OrmManyToManyMappingUiProvider.instance());
        providers.add(OrmEmbeddedMappingUiProvider.instance());
        providers.add(OrmTransientMappingUiProvider.instance());
    }

    @Override
    public Iterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultOrmAttributeMappingUiProviders() {
        if (this.defaultOrmAttributeMappingUiProviders == null) {
            this.defaultOrmAttributeMappingUiProviders = new ArrayList<DefaultAttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addDefaultOrmAttributeMappingUiProvidersTo(this.defaultOrmAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.defaultOrmAttributeMappingUiProviders);
    }

    protected void addDefaultOrmAttributeMappingUiProvidersTo(List<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> providers) {
    }
}

