/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.selection;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionEvent;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionParticipant;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class DefaultJpaSelectionManager
implements JpaSelectionManager {
    private IWorkbenchWindow window;
    private Set<IWorkbenchPage> pages = Collections.synchronizedSet(new HashSet());
    private IEditorPart activeEditor;
    private JpaSelection currentSelection;
    private Map<IWorkbenchPart, JpaSelectionParticipant> selectionParticipants = Collections.synchronizedMap(new HashMap());
    private IPageListener pageListener = new PageListener();
    private IPartListener2 partListener = new PartListener();

    public DefaultJpaSelectionManager() {
        this.currentSelection = DefaultJpaSelection.NULL_SELECTION;
    }

    void init(IWorkbenchWindow aWindow) {
        this.window = aWindow;
        aWindow.addPageListener(this.pageListener);
        this.initPage(aWindow.getActivePage());
    }

    private void initPage(IWorkbenchPage page) {
        if (page != null && !this.pages.contains(page)) {
            page.addPartListener(this.partListener);
            this.pages.add(page);
            this.activateEditor(page.getActiveEditor());
        }
    }

    private void disposePage(IWorkbenchPage page) {
        if (page != null && this.pages.contains(page)) {
            page.removePartListener(this.partListener);
            this.pages.remove(page);
        }
    }

    private void activateEditor(IEditorPart editor) {
        if (editor == this.activeEditor) {
            return;
        }
        if (this.activeEditor != null) {
            this.inactivateEditor(this.activeEditor);
        }
        this.initPart((IWorkbenchPart)editor);
        this.activeEditor = editor;
        this.selectEditor(this.activeEditor);
    }

    private void inactivateEditor(IEditorPart editor) {
    }

    void initPart(IWorkbenchPart part) {
        JpaSelectionParticipant selectionParticipant;
        if (part != null && this.selectionParticipants.get(part) == null && (selectionParticipant = (JpaSelectionParticipant)part.getAdapter(JpaSelectionParticipant.class)) != null) {
            this.selectionParticipants.put(part, selectionParticipant);
        }
    }

    private void selectEditor(IEditorPart editor) {
        this.selectPart((IWorkbenchPart)editor);
    }

    void selectPart(IWorkbenchPart part) {
        JpaSelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null) {
            this.select(selectionParticipant.getSelection(), selectionParticipant);
        }
    }

    void hidePart(IWorkbenchPart part) {
        JpaSelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null && selectionParticipant.disposeOnHide()) {
            this.closePart(part);
        }
    }

    void closePart(IWorkbenchPart part) {
        JpaSelectionParticipant selectionParticipant = this.getSelectionParticipant(part);
        if (selectionParticipant != null) {
            this.disposePart(part);
            this.checkForNoEditors();
        }
    }

    void disposePart(IWorkbenchPart part) {
        if (part != null && this.selectionParticipants.containsKey(part)) {
            this.selectionParticipants.remove(part).dispose();
        }
    }

    void checkForNoEditors() {
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage == null || activePage.getActiveEditor() == null) {
            this.select(DefaultJpaSelection.NULL_SELECTION, null);
        }
    }

    public void register(IWorkbenchPart part) {
        this.initPart(part);
    }

    public boolean isRegistered(IWorkbenchPart part) {
        return this.selectionParticipants.get(part) != null;
    }

    public void select(JpaSelection newSelection, JpaSelectionParticipant source) {
        if (this.currentSelection.equals(newSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        Object nonNullSource = source == null ? this : source;
        this.fireSelectionChange(new JpaSelectionEvent(newSelection, JpaSelectionEvent.SELECTION, nonNullSource));
    }

    public void deselect(JpaSelection oldSelection, JpaSelectionParticipant source) {
        if (this.currentSelection.equals(oldSelection)) {
            this.currentSelection = DefaultJpaSelection.NULL_SELECTION;
            Object nonNullSource = source == null ? this : source;
            this.fireSelectionChange(new JpaSelectionEvent(oldSelection, JpaSelectionEvent.DESELECTION, nonNullSource));
        }
    }

    private void fireSelectionChange(JpaSelectionEvent event) {
        for (JpaSelectionParticipant sp : this.selectionParticipants.values()) {
            sp.selectionChanged(event);
        }
    }

    private JpaSelectionParticipant getSelectionParticipant(IWorkbenchPart part) {
        return this.selectionParticipants.get(part);
    }

    public JpaSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public void dispose() {
        this.window.removePageListener(this.pageListener);
        this.selectionParticipants.clear();
        CloneIterator stream = new CloneIterator(this.pages);
        while (stream.hasNext()) {
            this.disposePage((IWorkbenchPage)stream.next());
        }
        stream = new CloneIterator(this.selectionParticipants.keySet());
        while (stream.hasNext()) {
            this.disposePart((IWorkbenchPart)stream.next());
        }
    }

    private class PageListener
    implements IPageListener {
        public void pageActivated(IWorkbenchPage page) {
        }

        PageListener() {
        }

        public void pageClosed(IWorkbenchPage page) {
            DefaultJpaSelectionManager.this.disposePage(page);
        }

        public void pageOpened(IWorkbenchPage page) {
            DefaultJpaSelectionManager.this.initPage(page);
        }
    }

    private class PartListener
    implements IPartListener2 {
        PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                DefaultJpaSelectionManager.this.initPart(part);
                DefaultJpaSelectionManager.this.selectPart(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                DefaultJpaSelectionManager.this.closePart(part);
                DefaultJpaSelectionManager.this.disposePart(part);
                DefaultJpaSelectionManager.this.checkForNoEditors();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                DefaultJpaSelectionManager.this.hidePart(part);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                DefaultJpaSelectionManager.this.initPart(part);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                DefaultJpaSelectionManager.this.initPart(part);
            }
        }
    }
}

