/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.ChangeTracking;
import org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.internal.EclipseLinkJpaFactory;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingAnnotation;

public class EclipseLinkJavaChangeTracking
extends AbstractJavaJpaContextNode
implements ChangeTracking {
    protected JavaResourcePersistentType resourcePersistentType;
    protected ChangeTrackingType specifiedType;

    public EclipseLinkJavaChangeTracking(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public JavaTypeMapping getParent() {
        return (JavaTypeMapping)super.getParent();
    }

    protected EclipseLinkJpaFactory getJpaFactory() {
        return (EclipseLinkJpaFactory)super.getJpaFactory();
    }

    protected String getChangeTrackingAnnotationName() {
        return "org.eclipse.persistence.annotations.ChangeTracking";
    }

    protected ChangeTrackingAnnotation getChangeTrackingAnnotation() {
        return (ChangeTrackingAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected void addChangeTrackingAnnotation() {
        this.resourcePersistentType.addSupportingAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected void removeChangeTrackingAnnotation() {
        this.resourcePersistentType.removeSupportingAnnotation(this.getChangeTrackingAnnotationName());
    }

    public ChangeTrackingType getType() {
        return this.getSpecifiedType() != null ? this.getSpecifiedType() : this.getDefaultType();
    }

    public ChangeTrackingType getDefaultType() {
        return DEFAULT_TYPE;
    }

    public ChangeTrackingType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(ChangeTrackingType newSpecifiedType) {
        if (this.specifiedType == newSpecifiedType) {
            return;
        }
        ChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        if (newSpecifiedType != null) {
            if (this.getChangeTrackingAnnotation() == null) {
                this.addChangeTrackingAnnotation();
            }
            this.getChangeTrackingAnnotation().setValue(ChangeTrackingType.toJavaResourceModel(newSpecifiedType));
        } else if (this.getChangeTrackingAnnotation() != null) {
            this.removeChangeTrackingAnnotation();
        }
        this.firePropertyChanged("specifiedTypeProperty", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(ChangeTrackingType newSpecifiedType) {
        ChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedTypeProperty", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    public void initialize(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        ChangeTrackingAnnotation changeTrackingAnnotation = this.getChangeTrackingAnnotation();
        this.specifiedType = this.changeTrackingType(changeTrackingAnnotation);
    }

    public void update(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        ChangeTrackingAnnotation changeTrackingAnnotation = this.getChangeTrackingAnnotation();
        this.setSpecifiedType_(this.changeTrackingType(changeTrackingAnnotation));
    }

    protected ChangeTrackingType changeTrackingType(ChangeTrackingAnnotation changeTracking) {
        if (changeTracking == null) {
            return null;
        }
        if (changeTracking.getValue() == null) {
            return ChangeTracking.DEFAULT_TYPE;
        }
        return ChangeTrackingType.fromJavaResourceModel(changeTracking.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        ChangeTrackingAnnotation changeTrackingAnnotation = this.getChangeTrackingAnnotation();
        TextRange textRange = changeTrackingAnnotation == null ? null : changeTrackingAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }
}

