/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.Logger;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.Logging;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.LoggingLevel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLogging
extends EclipseLinkPersistenceUnitProperties
implements Logging {
    private LoggingLevel level;
    private Boolean timestamp;
    private Boolean thread;
    private Boolean session;
    private Boolean exceptions;
    private String logFileLocation;
    private String logger;

    public EclipseLinkLogging(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.level = (LoggingLevel)this.getEnumValue("eclipselink.logging.level", LoggingLevel.values());
        this.timestamp = this.getBooleanValue("eclipselink.logging.timestamp");
        this.thread = this.getBooleanValue("eclipselink.logging.thread");
        this.session = this.getBooleanValue("eclipselink.logging.session");
        this.exceptions = this.getBooleanValue("eclipselink.logging.exceptions");
        this.logFileLocation = this.getStringValue("eclipselink.logging.file");
        this.logger = this.getLoggerProtertyValue();
    }

    private String getLoggerProtertyValue() {
        Logger standardLogger = (Logger)this.getEnumValue("eclipselink.logging.logger", Logger.values());
        if (!this.getPersistenceUnit().containsProperty("eclipselink.logging.logger")) {
            return null;
        }
        if (standardLogger == null) {
            return this.getStringValue("eclipselink.logging.logger");
        }
        return EclipseLinkLogging.getEclipseLinkStringValueOf((Object)standardLogger);
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.logging.level", "levelProperty");
        propertyNames.put("eclipselink.logging.timestamp", "timestampProperty");
        propertyNames.put("eclipselink.logging.thread", "threadProperty");
        propertyNames.put("eclipselink.logging.session", "sessionProperty");
        propertyNames.put("eclipselink.logging.exceptions", "exceptionsProperty");
        propertyNames.put("eclipselink.logging.file", "logFileLocationProperty");
        propertyNames.put("eclipselink.logging.logger", "loggerProperty");
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("levelProperty")) {
            this.levelChanged(event);
        } else if (aspectName.equals("timestampProperty")) {
            this.timestampChanged(event);
        } else if (aspectName.equals("threadProperty")) {
            this.threadChanged(event);
        } else if (aspectName.equals("sessionProperty")) {
            this.sessionChanged(event);
        } else if (aspectName.equals("exceptionsProperty")) {
            this.exceptionsChanged(event);
        } else if (aspectName.equals("logFileLocationProperty")) {
            this.logFileLocationChanged(event);
        } else if (aspectName.equals("loggerProperty")) {
            this.loggerChanged(event);
        } else {
            throw new IllegalArgumentException("Illegal event received - property not applicable: " + aspectName);
        }
    }

    @Override
    public LoggingLevel getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(LoggingLevel newLevel) {
        LoggingLevel old = this.level;
        this.level = newLevel;
        this.putProperty("levelProperty", (Object)newLevel);
        this.firePropertyChanged("levelProperty", (Object)old, (Object)newLevel);
    }

    private void levelChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        LoggingLevel newValue = (LoggingLevel)EclipseLinkLogging.getEnumValueOf((String)stringValue, (Enum[])LoggingLevel.values());
        LoggingLevel old = this.level;
        this.level = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public LoggingLevel getDefaultLevel() {
        return DEFAULT_LEVEL;
    }

    @Override
    public Boolean getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Boolean newTimestamp) {
        Boolean old = this.timestamp;
        this.timestamp = newTimestamp;
        this.putProperty("timestampProperty", newTimestamp);
        this.firePropertyChanged("timestampProperty", old, newTimestamp);
    }

    private void timestampChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf(stringValue);
        Boolean old = this.timestamp;
        this.timestamp = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultTimestamp() {
        return DEFAULT_TIMESTAMP;
    }

    @Override
    public Boolean getThread() {
        return this.thread;
    }

    @Override
    public void setThread(Boolean newThread) {
        Boolean old = this.thread;
        this.thread = newThread;
        this.putProperty("threadProperty", newThread);
        this.firePropertyChanged("threadProperty", old, newThread);
    }

    private void threadChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf(stringValue);
        Boolean old = this.thread;
        this.thread = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultThread() {
        return DEFAULT_THREAD;
    }

    @Override
    public Boolean getSession() {
        return this.session;
    }

    @Override
    public void setSession(Boolean newSession) {
        Boolean old = this.session;
        this.session = newSession;
        this.putProperty("sessionProperty", newSession);
        this.firePropertyChanged("sessionProperty", old, newSession);
    }

    private void sessionChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf(stringValue);
        Boolean old = this.session;
        this.session = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultSession() {
        return DEFAULT_SESSION;
    }

    @Override
    public Boolean getExceptions() {
        return this.exceptions;
    }

    @Override
    public void setExceptions(Boolean newExceptions) {
        Boolean old = this.exceptions;
        this.exceptions = newExceptions;
        this.putProperty("exceptionsProperty", newExceptions);
        this.firePropertyChanged("exceptionsProperty", old, newExceptions);
    }

    private void exceptionsChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf(stringValue);
        Boolean old = this.exceptions;
        this.exceptions = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultExceptions() {
        return DEFAULT_EXCEPTIONS;
    }

    @Override
    public String getLogFileLocation() {
        return this.logFileLocation;
    }

    @Override
    public void setLogFileLocation(String newLogFileLocation) {
        String old = this.logFileLocation;
        this.logFileLocation = newLogFileLocation;
        this.putProperty("logFileLocationProperty", newLogFileLocation);
        this.firePropertyChanged("logFileLocationProperty", old, newLogFileLocation);
    }

    private void logFileLocationChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.logFileLocation;
        this.logFileLocation = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultLogFileLocation() {
        return DEFAULT_LOG_FILE_LOCATION;
    }

    @Override
    public String getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger newLogger) {
        if (newLogger == null) {
            this.setLogger_(null);
            return;
        }
        this.setLogger_(EclipseLinkLogging.getEclipseLinkStringValueOf((Object)newLogger));
    }

    @Override
    public void setLogger(String newLogger) {
        if (newLogger == null) {
            this.setLogger_(null);
            return;
        }
        Logger logger = Logger.getLoggerFor(newLogger);
        if (logger == null) {
            this.setLogger_(newLogger);
        } else {
            this.setLogger(logger);
        }
    }

    private void setLogger_(String newLogger) {
        String old = this.logger;
        this.logger = newLogger;
        this.putProperty("loggerProperty", newLogger);
        this.firePropertyChanged("loggerProperty", old, newLogger);
    }

    private void loggerChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.logger;
        this.logger = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultLogger() {
        return DEFAULT_LOGGER;
    }
}

