/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.ddlgen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.wst.validation.ValidationFramework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkDDLGenerator {
    public static String ECLIPSELINK_DDL_GEN_JAR_VERSION = "1.0.100";
    public static String LAUNCH_CONFIG_NAME = "EclipseLink";
    public static String DDL_GEN_PACKAGE_NAME = "org.eclipse.jpt.eclipselink.core.ddlgen";
    public static String ECLIPSELINK_DDL_GEN_CLASS = String.valueOf(DDL_GEN_PACKAGE_NAME) + ".Main";
    public static String ECLIPSELINK_DDL_GEN_JAR = String.valueOf(DDL_GEN_PACKAGE_NAME) + "_";
    public static String PROPERTIES_FILE_NAME = "login.properties";
    public static String ECLIPSE_HOME = "ECLIPSE_HOME";
    public static String PLUGINS_DIR = "plugins";
    private IVMInstall jre;
    private ILaunchConfigurationWorkingCopy launchConfig;
    private ILaunch launch;
    private String puName;
    private JpaProject jpaProject;
    private String projectLocation;
    private boolean isDebug = false;

    public static void generate(String puName, JpaProject project, String projectLocation, IProgressMonitor monitor) {
        if (puName == null || puName.length() == 0 || project == null) {
            throw new NullPointerException();
        }
        new EclipseLinkDDLGenerator(puName, project, projectLocation, monitor).generate();
    }

    private EclipseLinkDDLGenerator(String puName, JpaProject jpaProject, String projectLocation, IProgressMonitor monitor) {
        this.puName = puName;
        this.jpaProject = jpaProject;
        this.projectLocation = projectLocation;
        this.initialize();
    }

    protected JpaPlatform getPlatform() {
        return this.jpaProject.getJpaPlatform();
    }

    protected ILaunch getLaunch() {
        return this.launch;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private IVMInstall getProjectJRE() throws CoreException {
        return JavaRuntime.getVMInstall((IJavaProject)this.jpaProject.getJavaProject());
    }

    protected void initialize() {
        try {
            this.jre = this.getProjectJRE();
            if (this.jre == null) {
                String message = "Could not identify the VM.";
                throw new RuntimeException(message);
            }
            this.launchConfig = this.buildLaunchConfiguration();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void generate() {
        this.preGenerate();
        String propertiesFile = String.valueOf(this.projectLocation) + "/" + PROPERTIES_FILE_NAME;
        try {
            this.initializeLaunchConfiguration(this.projectLocation, propertiesFile);
            this.saveLoginProperties(this.projectLocation, propertiesFile);
            this.launch = this.saveAndLaunchConfig();
            this.addLaunchListener();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeLaunchConfiguration(String projectLocation, String propertiesFile) throws CoreException {
        this.specifyJRE(this.jre.getName(), this.jre.getVMInstallType().getId());
        this.specifyProject(this.jpaProject.getProject().getName());
        this.specifyMainType(ECLIPSELINK_DDL_GEN_CLASS);
        this.specifyProgramArguments(this.puName, propertiesFile);
        this.specifyWorkingDir(projectLocation);
        this.specifyClasspathProperties(this.jpaProject, this.buildJdbcJarPath(), this.buildBootstrapJarPath());
    }

    private void addLaunchListener() {
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this.buildLaunchListener());
    }

    protected void preGenerate() {
        ConnectionProfile cp = this.jpaProject.getConnectionProfile();
        if (cp != null) {
            cp.disconnect();
        }
    }

    protected void postGenerate() {
        try {
            if (!this.isDebug) {
                this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        ConnectionProfile cp = this.jpaProject.getConnectionProfile();
        if (cp != null) {
            cp.connect();
        }
        this.validateProject();
    }

    protected void validateProject() {
        IProject project = this.jpaProject.getProject();
        ValidateJob job = new ValidateJob(project);
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }

    private IPath buildJdbcJarPath() {
        return new Path(this.getJpaProjectConnectionDriverJarList());
    }

    private String getJpaProjectConnectionDriverJarList() {
        ConnectionProfile cp = this.jpaProject.getConnectionProfile();
        return cp == null ? "" : cp.getDriverJarList();
    }

    private IPath buildBootstrapJarPath() {
        IPath path = JavaCore.getClasspathVariable((String)ECLIPSE_HOME).append(PLUGINS_DIR);
        File eclipseHome = path.toFile();
        ArrayList result = new ArrayList();
        this.findFile(ECLIPSELINK_DDL_GEN_JAR, eclipseHome, result);
        File ddlGenJarFile = (File)result.get(0);
        try {
            String ddlGenJarPath = ddlGenJarFile.getCanonicalPath();
            return new Path(ddlGenJarPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void findFile(String fileName, File directory, List<? super File> list) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(fileName)) {
                list.add(file);
            }
            if (file.isDirectory()) {
                this.findFile(fileName, file, list);
            }
            ++n2;
        }
    }

    private ILaunchesListener2 buildLaunchListener() {
        return new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                int i = 0;
                while (i < launches.length) {
                    ILaunch launch = launches[i];
                    if (launch.equals(EclipseLinkDDLGenerator.this.getLaunch())) {
                        EclipseLinkDDLGenerator.this.postGenerate();
                        return;
                    }
                    ++i;
                }
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
            }
        };
    }

    private void specifyJRE(String jreName, String vmId) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jreName);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmId);
    }

    private void specifyProject(String projectName) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
    }

    private void specifyMainType(String mainType) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
    }

    private void specifyProgramArguments(String puName, String propertiesPath) {
        StringBuffer programArguments = new StringBuffer();
        programArguments.append(this.buildPuNameArgument(puName));
        programArguments.append(this.buildPropertiesPathArgument(propertiesPath));
        programArguments.append(this.buildDebugArgument());
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private void specifyClasspathProperties(JpaProject project, IPath jdbcJar, IPath bootstrapJar) throws CoreException {
        IRuntimeClasspathEntry bootstrapEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)bootstrapJar);
        bootstrapEntry.setClasspathProperty(3);
        IRuntimeClasspathEntry defaultEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)project.getJavaProject());
        defaultEntry.setClasspathProperty(3);
        IRuntimeClasspathEntry jdbcEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jdbcJar);
        jdbcEntry.setClasspathProperty(3);
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        IRuntimeClasspathEntry systemLibsEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(bootstrapEntry.getMemento());
        classpath.add(defaultEntry.getMemento());
        classpath.add(jdbcEntry.getMemento());
        classpath.add(systemLibsEntry.getMemento());
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    private void specifyWorkingDir(String projectLocation) {
        File workingDir = new Path(projectLocation).toFile();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDir.getAbsolutePath());
    }

    private ILaunch saveAndLaunchConfig() throws CoreException {
        ILaunchConfiguration configuration = this.launchConfig.doSave();
        return configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
    }

    private ILaunchConfigurationWorkingCopy buildLaunchConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfig = null;
        this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        launchConfig = type.newInstance(null, LAUNCH_CONFIG_NAME);
        return launchConfig;
    }

    private void removeLaunchConfiguration(String launchConfigurationName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.getName().equals(launchConfigurationName)) {
                configuration.delete();
                break;
            }
            ++i;
        }
    }

    private void buildProjectLocationProperty(Properties properties, String location) {
        this.putProperty(properties, "eclipselink.application-location", location);
    }

    private void buildDDLModeProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.ddl-generation", "drop-and-create-tables");
        this.putProperty(properties, "eclipselink.ddl-generation.output-mode", "database");
    }

    private void buildConnectionProperties(Properties properties) {
        ConnectionProfile cp = this.jpaProject.getConnectionProfile();
        this.putProperty(properties, "eclipselink.jdbc.bind-parameters", "false");
        this.putProperty(properties, "eclipselink.jdbc.driver", cp == null ? "" : cp.getDriverClassName());
        this.putProperty(properties, "eclipselink.jdbc.url", cp == null ? "" : cp.getURL());
        this.putProperty(properties, "eclipselink.jdbc.user", cp == null ? "" : cp.getUserName());
        this.putProperty(properties, "eclipselink.jdbc.password", cp == null ? "" : cp.getUserPassword());
    }

    private void buildConnectionPoolingProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.jdbc.read-connections.shared", "true");
    }

    private void buildLoggingProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.logging.level", "FINE");
        this.putProperty(properties, "eclipselink.logging.timestamp", "false");
        this.putProperty(properties, "eclipselink.logging.thread", "false");
        this.putProperty(properties, "eclipselink.logging.session", "false");
        this.putProperty(properties, "eclipselink.logging.exceptions", "true");
    }

    private void buildCustomizationProperties(Properties properties) {
        this.putProperty(properties, "eclipselink.orm.throw.exceptions", "true");
    }

    private void putProperty(Properties properties, String key, String value) {
        properties.put(key, value == null ? "" : value);
    }

    private void saveLoginProperties(String projectLocation, String propertiesFile) {
        Properties elProperties = new Properties();
        this.buildConnectionProperties(elProperties);
        this.buildConnectionPoolingProperties(elProperties);
        this.buildLoggingProperties(elProperties);
        this.buildCustomizationProperties(elProperties);
        this.buildDDLModeProperties(elProperties);
        this.buildProjectLocationProperty(elProperties, projectLocation);
        try {
            File file = new File(propertiesFile);
            file.createNewFile();
            FileOutputStream stream = new FileOutputStream(file);
            elProperties.store(stream, null);
            stream.close();
        }
        catch (Exception e) {
            String message = "Error saving: " + propertiesFile;
            throw new RuntimeException(message, e);
        }
    }

    private String buildPuNameArgument(String puName) {
        return " -pu \"" + puName + "\"";
    }

    private String buildPropertiesPathArgument(String propertiesFile) {
        return " -p \"" + propertiesFile + "\"";
    }

    private String buildDebugArgument() {
        return this.isDebug ? " -debug" : "";
    }

    private class ValidateJob
    extends Job {
        private IProject project;

        public ValidateJob(IProject project) {
            super(JptCoreMessages.VALIDATE_JOB);
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            try {
                ValidationFramework.getDefault().validate(new IProject[]{this.project}, true, false, monitor);
            }
            catch (CoreException coreException) {
                status = Status.CANCEL_STATUS;
            }
            return status;
        }
    }
}

