/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.resource.java.TimeOfDayAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeOfDayImpl
extends AbstractResourceAnnotation<Type>
implements TimeOfDayAnnotation {
    private final AnnotationElementAdapter<Integer> hourAdapter;
    private final AnnotationElementAdapter<Integer> minuteAdapter;
    private final AnnotationElementAdapter<Integer> secondAdapter;
    private final AnnotationElementAdapter<Integer> millisecondAdapter;
    private final DeclarationAnnotationElementAdapter<Integer> hourDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<Integer> minuteDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<Integer> secondDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<Integer> millisecondDeclarationAdapter;
    private Integer hour;
    private Integer minute;
    private Integer second;
    private Integer millisecond;

    protected TimeOfDayImpl(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa) {
        super(parent, (Member)type, daa);
        this.hourDeclarationAdapter = TimeOfDayImpl.buildHourAdapter(daa);
        this.hourAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.hourDeclarationAdapter);
        this.minuteDeclarationAdapter = TimeOfDayImpl.buildMinuteAdapter(daa);
        this.minuteAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.minuteDeclarationAdapter);
        this.secondDeclarationAdapter = TimeOfDayImpl.buildSecondAdapter(daa);
        this.secondAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.secondDeclarationAdapter);
        this.millisecondDeclarationAdapter = TimeOfDayImpl.buildMillisecondAdapter(daa);
        this.millisecondAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.millisecondDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.TimeOfDay";
    }

    @Override
    public Integer getHour() {
        return this.hour;
    }

    @Override
    public void setHour(Integer newHour) {
        if (this.attributeValueHasNotChanged(this.hour, newHour)) {
            return;
        }
        Integer oldHour = this.hour;
        this.hour = newHour;
        this.hourAdapter.setValue((Object)newHour);
        this.firePropertyChanged("hourProperty", oldHour, newHour);
    }

    @Override
    public Integer getMinute() {
        return this.minute;
    }

    @Override
    public void setMinute(Integer newMinute) {
        if (this.attributeValueHasNotChanged(this.minute, newMinute)) {
            return;
        }
        Integer oldMinute = this.minute;
        this.minute = newMinute;
        this.minuteAdapter.setValue((Object)newMinute);
        this.firePropertyChanged("minuteProperty", oldMinute, newMinute);
    }

    @Override
    public Integer getSecond() {
        return this.second;
    }

    @Override
    public void setSecond(Integer newSecond) {
        if (this.attributeValueHasNotChanged(this.second, newSecond)) {
            return;
        }
        Integer oldSecond = this.second;
        this.second = newSecond;
        this.secondAdapter.setValue((Object)newSecond);
        this.firePropertyChanged("secondProperty", oldSecond, newSecond);
    }

    @Override
    public Integer getMillisecond() {
        return this.millisecond;
    }

    @Override
    public void setMillisecond(Integer newMillisecond) {
        if (this.attributeValueHasNotChanged(this.millisecond, newMillisecond)) {
            return;
        }
        Integer oldMillisecond = this.millisecond;
        this.millisecond = newMillisecond;
        this.millisecondAdapter.setValue((Object)newMillisecond);
        this.firePropertyChanged("millisecondProperty", oldMillisecond, newMillisecond);
    }

    @Override
    public TextRange getHourTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.hourDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getMinuteTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.minuteDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getSecondTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.secondDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getMillisecondTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.millisecondDeclarationAdapter, astRoot);
    }

    public void initialize(CompilationUnit astRoot) {
        this.hour = this.hour(astRoot);
        this.minute = this.minute(astRoot);
        this.second = this.second(astRoot);
        this.millisecond = this.millisecond(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setHour(this.hour(astRoot));
        this.setMinute(this.minute(astRoot));
        this.setSecond(this.second(astRoot));
        this.setMillisecond(this.millisecond(astRoot));
    }

    protected Integer hour(CompilationUnit astRoot) {
        return (Integer)this.hourAdapter.getValue(astRoot);
    }

    protected Integer minute(CompilationUnit astRoot) {
        return (Integer)this.minuteAdapter.getValue(astRoot);
    }

    protected Integer second(CompilationUnit astRoot) {
        return (Integer)this.secondAdapter.getValue(astRoot);
    }

    protected Integer millisecond(CompilationUnit astRoot) {
        return (Integer)this.millisecondAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildHourAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "hour", false, NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMinuteAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "minute", false, NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildSecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "second", false, NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMillisecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "millisecond", false, NumberIntegerExpressionConverter.instance());
    }
}

