/*******************************************************************************
 * Copyright (c) 2008 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.eclipselink.ui.internal.persistence.general;

import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.JptEclipseLinkCorePlugin;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.GeneralProperties;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.persistence.details.PersistenceUnitMappingFilesComposite;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/**
 * Here the layout of this pane:
 * <pre>
 * -----------------------------------------------------------------------------
 * | ------------------------------------------------------------------------- |
 * | |                                                                       | |
 * | | AddRemoveListPane                                                     | |
 * | |                                                                       | |
 * | ------------------------------------------------------------------------- |
 * -----------------------------------------------------------------------------</pre>
 *
 * @see PersistenceUnit
 * @see PersistenceUnitGeneralComposite - The parent container
 * @see AddRemoveListPane
 *
 * @version 2.0
 * @since 2.0
 */
public class EclipseLinkPersistenceUnitMappingFilesComposite extends PersistenceUnitMappingFilesComposite
{
	/**
	 * Creates a new <code>PersistenceUnitMappingFilesComposite</code>.
	 *
	 * @param parentPane The parent pane of this one
	 * @param parent The parent container
	 */
	public EclipseLinkPersistenceUnitMappingFilesComposite(Pane<? extends PersistenceUnit> parentPane,
	                                            Composite parent) {

		super(parentPane, parent);
	}
	
	@Override
	protected boolean isMappingFile(String contentTypeId) {
		return super.isMappingFile(contentTypeId) ||
					contentTypeId.equals(JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE);
	}

	@Override
	protected void initializeLayout(Composite container) {
		addMappingFilesList(container);
		addTriStateCheckBoxWithDefault(
			container,
			EclipseLinkUiMessages.PersistenceXmlGeneralTab_excludeEclipselinkOrm,
			this.buildExcludeEclipselinkOrmHolder(),
			this.buildExcludeEclipselinkOrmStringHolder(),
			null
		);

	}
	
	
	protected PropertyValueModel<GeneralProperties> buildGeneralPropertiesHolder() {
		return new TransformationPropertyValueModel<PersistenceUnit, GeneralProperties>(getSubjectHolder()) {
			@Override
			protected GeneralProperties transform_(PersistenceUnit persistenceUnit) {
				return ((EclipseLinkPersistenceUnit) persistenceUnit).getGeneralProperties();
			}
		};
	}
	
	private WritablePropertyValueModel<Boolean> buildExcludeEclipselinkOrmHolder() {
		return new PropertyAspectAdapter<GeneralProperties, Boolean>(
			buildGeneralPropertiesHolder(),
			GeneralProperties.EXCLUDE_ECLIPSELINK_ORM_PROPERTY)
		{
			@Override
			protected Boolean buildValue_() {
				return this.subject.getExcludeEclipselinkOrm();
			}

			@Override
			protected void setValue_(Boolean value) {
				this.subject.setExcludeEclipselinkOrm(value);
			}

			@Override
			protected void subjectChanged() {
				Object oldValue = this.getValue();
				super.subjectChanged();
				Object newValue = this.getValue();

				// Make sure the default value is appended to the text
				if (oldValue == newValue && newValue == null) {
					this.fireAspectChange(Boolean.TRUE, newValue);
				}
			}
		};
	}

	private PropertyValueModel<String> buildExcludeEclipselinkOrmStringHolder() {

		return new TransformationPropertyValueModel<Boolean, String>(buildExcludeEclipselinkOrmHolder()) {

			@Override
			protected String transform(Boolean value) {

				if ((getSubject() != null) && (value == null)) {

					Boolean defaultValue = ((EclipseLinkPersistenceUnit) getSubject()).getGeneralProperties().getDefaultExcludeEclipselinkOrm();

					if (defaultValue != null) {

						String defaultStringValue = defaultValue ? EclipseLinkUiMessages.Boolean_True :
																			EclipseLinkUiMessages.Boolean_False;

						return NLS.bind(
							EclipseLinkUiMessages.PersistenceXmlGeneralTab_excludeEclipselinkOrmWithDefault,
							defaultStringValue
						);
					}
				}
				return EclipseLinkUiMessages.PersistenceXmlGeneralTab_excludeEclipselinkOrm;
			}
		};
	}
}