/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jpt.core.tests.internal.context.JptCoreContextModelTests;
import org.eclipse.jpt.core.tests.internal.model.JptCoreModelTests;
import org.eclipse.jpt.core.tests.internal.resource.JptCoreResourceModelTests;
import org.eclipse.jpt.core.tests.internal.utility.jdt.JptCoreUtilityJdtTests;

public class JptCoreTests {
    private static final String JPA_JAR_PROPERTY = "org.eclipse.jpt.jpa.jar";

    public static Test suite() {
        return JptCoreTests.suite(false);
    }

    public static Test suite(boolean all) {
        String quantity = all ? "All" : "Most";
        TestSuite suite = new TestSuite(String.valueOf(quantity) + " JPT Core Tests");
        if (JptCoreTests.jpaJarPropertyExists() && JptCoreTests.jpaJarFileExists()) {
            suite.addTest(JptCoreUtilityJdtTests.suite(all));
            suite.addTest(JptCoreModelTests.suite(all));
            suite.addTest(JptCoreResourceModelTests.suite(all));
            suite.addTest(JptCoreContextModelTests.suite(all));
        } else {
            String message = !JptCoreTests.jpaJarPropertyExists() ? "missing Java system property: \"org.eclipse.jpt.jpa.jar\"" : "missing JPA jar file: \"" + JptCoreTests.getJpaJarProperty() + "\"";
            suite.addTest(TestSuite.warning((String)message));
        }
        return suite;
    }

    public static boolean jpaJarPropertyExists() {
        String jpaJarName = JptCoreTests.getJpaJarProperty();
        return jpaJarName != null;
    }

    public static boolean jpaJarFileExists() {
        File file = new File(JptCoreTests.getJpaJarProperty());
        return file.exists();
    }

    public static String getJpaJarProperty() {
        return System.getProperty(JPA_JAR_PROPERTY);
    }

    private JptCoreTests() {
        throw new UnsupportedOperationException();
    }
}

