/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.MappingFile;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.resource.orm.OrmResourceModelProvider;
import org.eclipse.jpt.core.internal.resource.persistence.PersistenceResourceModelProvider;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class ContextModelTestCase
extends AnnotationTestCase {
    protected static final String BASE_PROJECT_NAME = "ContextModelTestProject";
    protected PersistenceResourceModelProvider persistenceResourceModelProvider;
    protected OrmResourceModelProvider ormResourceModelProvider;

    protected ContextModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.persistenceResourceModelProvider = PersistenceResourceModelProvider.getDefaultModelProvider((IProject)this.getJavaProject().getProject());
        this.ormResourceModelProvider = OrmResourceModelProvider.getDefaultModelProvider((IProject)this.getJavaProject().getProject());
        this.waitForWorkspaceJobs();
    }

    protected void tearDown() throws Exception {
        this.persistenceResourceModelProvider = null;
        this.ormResourceModelProvider = null;
        super.tearDown();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return this.buildJpaProject(BASE_PROJECT_NAME, autoBuild, this.buildJpaConfigDataModel());
    }

    protected TestJpaProject buildJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws Exception {
        return TestJpaProject.buildJpaProject(projectName, autoBuild, jpaConfig);
    }

    protected IDataModel buildJpaConfigDataModel() {
        return null;
    }

    protected JpaProject jpaProject() {
        return this.getJavaProject().getJpaProject();
    }

    protected void waitForWorkspaceJobs() {
        Job waitJob = new Job("Wait job"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        waitJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        waitJob.schedule();
        try {
            waitJob.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    protected PersistenceResource persistenceResource() {
        return (PersistenceResource)this.persistenceResourceModelProvider.getResource();
    }

    protected OrmResource ormResource() {
        return (OrmResource)this.ormResourceModelProvider.getResource();
    }

    protected XmlPersistence xmlPersistence() {
        return this.persistenceResource().getPersistence();
    }

    protected EntityMappings entityMappings() {
        MappingFile mappingFile = ((MappingFileRef)this.persistenceUnit().mappingFileRefs().next()).getMappingFile();
        return mappingFile == null ? null : (EntityMappings)mappingFile.getRoot();
    }

    protected XmlPersistenceUnit xmlPersistenceUnit() {
        return (XmlPersistenceUnit)this.persistenceResource().getPersistence().getPersistenceUnits().get(0);
    }

    protected PersistenceUnit persistenceUnit() {
        return (PersistenceUnit)this.getRootContextNode().getPersistenceXml().getPersistence().persistenceUnits().next();
    }

    protected ClassRef classRef() {
        return (ClassRef)this.persistenceUnit().specifiedClassRefs().next();
    }

    protected JavaPersistentType javaPersistentType() {
        return this.classRef().getJavaPersistentType();
    }

    protected Entity javaEntity() {
        return (Entity)this.javaPersistentType().getMapping();
    }

    protected void addXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass(className);
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
    }

    protected void removeXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        XmlJavaClassRef xmlJavaClassRefToRemove = null;
        for (XmlJavaClassRef xmlJavaClassRef : xmlPersistenceUnit.getClasses()) {
            if (!xmlJavaClassRef.getJavaClass().equals(className)) continue;
            xmlJavaClassRefToRemove = xmlJavaClassRef;
        }
        if (xmlJavaClassRefToRemove == null) {
            throw new IllegalArgumentException();
        }
        xmlPersistenceUnit.getClasses().remove(xmlJavaClassRefToRemove);
    }

    protected JpaRootContextNode getRootContextNode() {
        return this.getJavaProject().getJpaProject().getRootContextNode();
    }

    protected TestJpaProject getJavaProject() {
        return (TestJpaProject)super.getJavaProject();
    }

    protected void deleteResource(Resource resource) throws CoreException {
        WorkbenchResourceHelper.deleteResource((Resource)resource);
    }
}

