/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaAssociationOverrideTests
extends ContextModelTestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE_NAME";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestEntityWithAssociationOverride() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AssociationOverride"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@AssociationOverride(name=\"MY_ASSOCIATION_OVERRIDE_NAME\")");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public JavaAssociationOverrideTests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        AssociationOverride javaAssociationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        JavaAssociationOverrideTests.assertTrue((boolean)this.javaEntity().associationOverrides().hasNext());
        associationOverrideResource.setName("FOO");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        associationOverrideResource.setName(null);
        JavaAssociationOverrideTests.assertNull((Object)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertNull((Object)associationOverrideResource.getName());
        associationOverrideResource.setName("FOO");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        typeResource.removeSupportingAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        JavaAssociationOverrideTests.assertFalse((boolean)this.javaEntity().specifiedAssociationOverrides().hasNext());
        JavaAssociationOverrideTests.assertFalse((boolean)typeResource.supportingAnnotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").hasNext());
    }

    public void testModifyName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        AssociationOverride javaAssociationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        JavaAssociationOverrideTests.assertTrue((boolean)this.javaEntity().associationOverrides().hasNext());
        javaAssociationOverride.setName("foo");
        JavaAssociationOverrideTests.assertEquals((String)"foo", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"foo", (String)associationOverrideResource.getName());
        javaAssociationOverride.setName(null);
        JavaAssociationOverrideTests.assertNull((Object)javaAssociationOverride.getName());
        associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertNull((Object)associationOverrideResource.getName());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        AssociationOverride javaAssociationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        JoinColumn joinColumn = javaAssociationOverride.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(0).getName());
        JoinColumn joinColumn2 = javaAssociationOverride.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(1).getName());
        JoinColumn joinColumn3 = javaAssociationOverride.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
        ListIterator joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn2, joinColumns.next());
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn3, joinColumns.next());
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        AssociationOverride javaAssociationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        javaAssociationOverride.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        javaAssociationOverride.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        javaAssociationOverride.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((int)3, (int)associationOverrideResource.joinColumnsSize());
        javaAssociationOverride.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)2, (int)associationOverrideResource.joinColumnsSize());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        javaAssociationOverride.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)1, (int)associationOverrideResource.joinColumnsSize());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        javaAssociationOverride.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)0, (int)associationOverrideResource.joinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        AssociationOverride javaAssociationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        javaAssociationOverride.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        javaAssociationOverride.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        javaAssociationOverride.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((int)3, (int)associationOverrideResource.joinColumnsSize());
        javaAssociationOverride.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
        javaAssociationOverride.moveSpecifiedJoinColumn(0, 1);
        joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        AssociationOverride javaAssociationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        associationOverrideResource.addJoinColumn(0);
        associationOverrideResource.addJoinColumn(1);
        associationOverrideResource.addJoinColumn(2);
        associationOverrideResource.joinColumnAt(0).setName("FOO");
        associationOverrideResource.joinColumnAt(1).setName("BAR");
        associationOverrideResource.joinColumnAt(2).setName("BAZ");
        ListIterator joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(2, 0);
        joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(0, 1);
        joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        joinColumns = javaAssociationOverride.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(0);
        JavaAssociationOverrideTests.assertFalse((boolean)javaAssociationOverride.specifiedJoinColumns().hasNext());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)this.javaEntity().specifiedAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        associationOverrideResource.setName("FOO");
        specifiedAssociationOverride = (AssociationOverride)this.javaEntity().specifiedAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)specifiedAssociationOverride.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)this.javaEntity().specifiedAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        specifiedAssociationOverride.setName("FOO");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getSupportingAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
    }

    public void testDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaAssociationOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAssociationOverrideTests.assertEquals((int)1, (int)entity.virtualAssociationOverridesSize());
        AssociationOverride associationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverride.getName());
    }

    public void testIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = this.javaEntity();
        JavaAssociationOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAssociationOverrideTests.assertEquals((int)1, (int)entity.virtualAssociationOverridesSize());
        AssociationOverride associationOverride = (AssociationOverride)entity.virtualAssociationOverrides().next();
        JavaAssociationOverrideTests.assertTrue((boolean)associationOverride.isVirtual());
    }
}

