/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.MappedSuperclass;
import org.eclipse.jpt.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaEmbeddableTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEmbeddable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable");
            }
        });
    }

    public JavaEmbeddableTests(String name) {
        super(name);
    }

    public void testMorphToEntity() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaPersistentType().setMappingKey("entity");
        JavaEmbeddableTests.assertTrue((boolean)(this.javaPersistentType().getMapping() instanceof Entity));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEmbeddableTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Embeddable"));
    }

    public void testMorphToMappedSuperclass() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaPersistentType().setMappingKey("mappedSuperclass");
        JavaEmbeddableTests.assertTrue((boolean)(this.javaPersistentType().getMapping() instanceof MappedSuperclass));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEmbeddableTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Embeddable"));
    }

    public void testMorphToNull() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaEmbeddableTests.assertTrue((boolean)(this.javaPersistentType().getMapping() instanceof JavaNullTypeMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEmbeddableTests.assertNull((Object)typeResource.getMappingAnnotation("javax.persistence.Embeddable"));
    }

    public void testEmbeddable() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEmbeddableTests.assertTrue((boolean)(this.javaPersistentType().getMapping() instanceof Embeddable));
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        Iterator overridableAttributeNames = embeddable.overridableAttributeNames();
        JavaEmbeddableTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        Iterator overridableAssociationNames = embeddable.overridableAssociationNames();
        JavaEmbeddableTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testTableNameIsInvalid() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.tableNameIsInvalid("test.AnnotationTestType"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.tableNameIsInvalid("FOO"));
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        JavaEmbeddableTests.assertTrue((boolean)embeddable.attributeMappingKeyAllowed("basic"));
        JavaEmbeddableTests.assertTrue((boolean)embeddable.attributeMappingKeyAllowed("transient"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("id"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("embedded"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("embeddedId"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("version"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("oneToOne"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("manyToOne"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("oneToMany"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testAssociatedTables() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.associatedTables().hasNext());
    }

    public void testAssociatedTablesIncludingInherited() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.associatedTablesIncludingInherited().hasNext());
    }

    public void testAssociatedTableNamesIncludingInherited() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.associatedTableNamesIncludingInherited().hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        Iterator overridableAttributeNames = embeddable.overridableAttributeNames();
        JavaEmbeddableTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.javaPersistentType().getMapping();
        Iterator overridableAssociationNames = embeddable.overridableAssociationNames();
        JavaEmbeddableTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }
}

