/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaPrimaryKeyJoinColumnTests
extends ContextModelTestCase {
    private static final String PRIMARY_KEY_JOIN_COLUMN_NAME = "MY_PRIMARY_KEY_JOIN_COLUMN";
    private static final String COLUMN_DEFINITION = "MY_COLUMN_DEFINITION";

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithPrimaryKeyJoinColumn() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.PrimaryKeyJoinColumn"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@PrimaryKeyJoinColumn(name=\"MY_PRIMARY_KEY_JOIN_COLUMN\")");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public JavaPrimaryKeyJoinColumnTests(String name) {
        super(name);
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)PRIMARY_KEY_JOIN_COLUMN_NAME, (String)specifiedPkJoinColumn.getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumnResource.setName("FOO");
        specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)specifiedPkJoinColumn.getName());
    }

    public void testGetDefaultNameNoSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn pkJoinColumn = this.javaEntity().getDefaultPrimaryKeyJoinColumn();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)pkJoinColumn.getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)this.javaEntity().getDefaultPrimaryKeyJoinColumn());
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)specifiedPkJoinColumn.getDefaultName());
        JavaPersistentAttribute idAttribute = this.javaPersistentType().getAttributeNamed("id");
        idAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getDefaultName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)PRIMARY_KEY_JOIN_COLUMN_NAME, (String)specifiedPkJoinColumn.getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        specifiedPkJoinColumn.setSpecifiedName("foo");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)specifiedPkJoinColumn.getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)pkJoinColumn.getName());
        specifiedPkJoinColumn.setSpecifiedName(null);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getSpecifiedName());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)pkJoinColumn);
    }

    public void testGetColumnDefinition() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getColumnDefinition());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        column.setColumnDefinition(COLUMN_DEFINITION);
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)COLUMN_DEFINITION, (String)specifiedPkJoinColumn.getColumnDefinition());
        column.setColumnDefinition(null);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getColumnDefinition());
        typeResource.removeSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertEquals((int)0, (int)this.javaEntity().specifiedPrimaryKeyJoinColumnsSize());
    }

    public void testSetColumnDefinition() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        specifiedPkJoinColumn.setColumnDefinition("foo");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)column.getColumnDefinition());
        specifiedPkJoinColumn.setColumnDefinition(null);
        column = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testGetSpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumnResource.setReferencedColumnName("FOO");
        specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testGetDefaultReferencedColumnNameNoSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn pkJoinColumn = this.javaEntity().getDefaultPrimaryKeyJoinColumn();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)pkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testGetDefaultReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)this.javaEntity().getDefaultPrimaryKeyJoinColumn());
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)specifiedPkJoinColumn.getDefaultReferencedColumnName());
        JavaPersistentAttribute idAttribute = this.javaPersistentType().getAttributeNamed("id");
        idAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testGetReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumnResource.setReferencedColumnName("FOO");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)specifiedPkJoinColumn.getReferencedColumnName());
    }

    public void testSetSpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        specifiedPkJoinColumn.setSpecifiedReferencedColumnName("foo");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PrimaryKeyJoinColumnAnnotation pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)pkJoinColumn.getReferencedColumnName());
        specifiedPkJoinColumn.setSpecifiedName(null);
        specifiedPkJoinColumn.setSpecifiedReferencedColumnName(null);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)pkJoinColumn);
    }

    public void testIsVirtual() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertFalse((boolean)specifiedPkJoinColumn.isVirtual());
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)this.javaEntity().getDefaultPrimaryKeyJoinColumn());
        this.javaEntity().removeSpecifiedPrimaryKeyJoinColumn(0);
        JavaPrimaryKeyJoinColumnTests.assertTrue((boolean)this.javaEntity().getDefaultPrimaryKeyJoinColumn().isVirtual());
    }

    public void testIsReferencedColumnResolved() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertFalse((boolean)specifiedPkJoinColumn.isReferencedColumnResolved());
    }

    public void testDbColumn() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getDbColumn());
    }

    public void testDbReferencedColumn() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getReferencedDbColumn());
    }

    public void testDbTable() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        PrimaryKeyJoinColumn specifiedPkJoinColumn = (PrimaryKeyJoinColumn)this.javaEntity().specifiedPrimaryKeyJoinColumns().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getDbTable());
    }
}

