/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.SequenceGenerator;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaSequenceGeneratorTests
extends ContextModelTestCase {
    private static final String SEQUENCE_GENERATOR_NAME = "MY_SEQUENCE_GENERATOR";

    private ICompilationUnit createTestEntityWithSequenceGenerator() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SequenceGenerator", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@SequenceGenerator(name=\"MY_SEQUENCE_GENERATOR\")");
            }
        });
    }

    public JavaSequenceGeneratorTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((String)SEQUENCE_GENERATOR_NAME, (String)idMapping.getSequenceGenerator().getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setName("foo");
        JavaSequenceGeneratorTests.assertEquals((String)"foo", (String)idMapping.getSequenceGenerator().getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((String)SEQUENCE_GENERATOR_NAME, (String)idMapping.getSequenceGenerator().getName());
        idMapping.getSequenceGenerator().setName("foo");
        JavaSequenceGeneratorTests.assertEquals((String)"foo", (String)idMapping.getSequenceGenerator().getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((String)"foo", (String)sequenceGenerator.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((String)SEQUENCE_GENERATOR_NAME, (String)idMapping.getSequenceGenerator().getName());
        idMapping.getSequenceGenerator().setName(null);
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getSequenceGenerator());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertNull((Object)sequenceGenerator);
    }

    public void testGetInitialValue() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((Object)SequenceGenerator.DEFAULT_INITIAL_VALUE, (Object)idMapping.getSequenceGenerator().getInitialValue());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setInitialValue(Integer.valueOf(82));
        JavaSequenceGeneratorTests.assertEquals((Object)82, (Object)idMapping.getSequenceGenerator().getInitialValue());
        JavaSequenceGeneratorTests.assertEquals((Object)82, (Object)idMapping.getSequenceGenerator().getSpecifiedInitialValue());
    }

    public void testGetDefaultInitialValue() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((Object)SequenceGenerator.DEFAULT_INITIAL_VALUE, (Object)idMapping.getSequenceGenerator().getDefaultInitialValue());
        idMapping.getSequenceGenerator().setSpecifiedInitialValue(Integer.valueOf(82));
        JavaSequenceGeneratorTests.assertEquals((Object)SequenceGenerator.DEFAULT_INITIAL_VALUE, (Object)idMapping.getSequenceGenerator().getDefaultInitialValue());
        JavaSequenceGeneratorTests.assertEquals((Object)82, (Object)idMapping.getSequenceGenerator().getSpecifiedInitialValue());
    }

    public void testSetSpecifiedInitialValue() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getSequenceGenerator().setSpecifiedInitialValue(Integer.valueOf(20));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((Object)20, (Object)sequenceGenerator.getInitialValue());
        idMapping.getSequenceGenerator().setName(null);
        idMapping.getSequenceGenerator().setSpecifiedInitialValue(null);
        JavaSequenceGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator"));
    }

    public void testGetAllocationSize() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((Object)Generator.DEFAULT_ALLOCATION_SIZE, (Object)idMapping.getSequenceGenerator().getAllocationSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setAllocationSize(Integer.valueOf(20));
        JavaSequenceGeneratorTests.assertEquals((Object)20, (Object)idMapping.getSequenceGenerator().getAllocationSize());
        JavaSequenceGeneratorTests.assertEquals((Object)20, (Object)idMapping.getSequenceGenerator().getSpecifiedAllocationSize());
    }

    public void testGetDefaultAllocationSize() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((Object)Generator.DEFAULT_ALLOCATION_SIZE, (Object)idMapping.getSequenceGenerator().getDefaultAllocationSize());
        idMapping.getSequenceGenerator().setSpecifiedAllocationSize(Integer.valueOf(20));
        JavaSequenceGeneratorTests.assertEquals((Object)Generator.DEFAULT_ALLOCATION_SIZE, (Object)idMapping.getSequenceGenerator().getDefaultAllocationSize());
        JavaSequenceGeneratorTests.assertEquals((Object)20, (Object)idMapping.getSequenceGenerator().getSpecifiedAllocationSize());
    }

    public void testSetSpecifiedAllocationSize() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getSequenceGenerator().setSpecifiedAllocationSize(Integer.valueOf(25));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((Object)25, (Object)sequenceGenerator.getAllocationSize());
        idMapping.getSequenceGenerator().setName(null);
        idMapping.getSequenceGenerator().setSpecifiedAllocationSize(null);
        JavaSequenceGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator"));
    }

    public void testGetSequenceName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getSequenceGenerator().getSequenceName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setSequenceName("mySequenceName");
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)idMapping.getSequenceGenerator().getSequenceName());
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)idMapping.getSequenceGenerator().getSpecifiedSequenceName());
    }

    public void testGetDefaultSequenceName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getSequenceGenerator().getDefaultSequenceName());
        idMapping.getSequenceGenerator().setSpecifiedSequenceName("mySequenceName");
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getSequenceGenerator().getDefaultSequenceName());
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)idMapping.getSequenceGenerator().getSpecifiedSequenceName());
    }

    public void testSetSpecifiedSequenceName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.javaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getSequenceGenerator().setSpecifiedSequenceName("mySequenceName");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)sequenceGenerator.getSequenceName());
        idMapping.getSequenceGenerator().setName(null);
        idMapping.getSequenceGenerator().setSpecifiedSequenceName(null);
        JavaSequenceGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.SequenceGenerator"));
    }
}

