/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBasic;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmColumnTests
extends ContextModelTestCase {
    public OrmColumnTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setName("FOO");
        this.ormResource().save(null);
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getName());
        basic.getColumn().setName(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn().getName());
        basic.getColumn().setName("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getName());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedName("foo");
        OrmColumnTests.assertEquals((String)"foo", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"foo", (String)basic.getColumn().getName());
        ormColumn.setSpecifiedName(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setColumnDefinition("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getColumnDefinition());
        basic.getColumn().setColumnDefinition(null);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn().getColumnDefinition());
        basic.getColumn().setColumnDefinition("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getColumnDefinition());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifyColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setColumnDefinition("foo");
        OrmColumnTests.assertEquals((String)"foo", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((String)"foo", (String)basic.getColumn().getColumnDefinition());
        ormColumn.setColumnDefinition(null);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedTable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setTable("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getTable());
        basic.getColumn().setTable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertNull((Object)basic.getColumn().getTable());
        basic.getColumn().setTable("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getTable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedTable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedTable("foo");
        OrmColumnTests.assertEquals((String)"foo", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals((String)"foo", (String)basic.getColumn().getTable());
        ormColumn.setSpecifiedTable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedNullable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setNullable(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getNullable());
        basic.getColumn().setNullable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn().getNullable());
        basic.getColumn().setNullable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getNullable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedNullable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedNullable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getNullable());
        ormColumn.setSpecifiedNullable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedUpdatable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setUpdatable(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getUpdatable());
        basic.getColumn().setUpdatable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn().getUpdatable());
        basic.getColumn().setUpdatable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUpdatable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedUpdatable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedUpdatable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUpdatable());
        ormColumn.setSpecifiedUpdatable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedInsertable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setInsertable(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getInsertable());
        basic.getColumn().setInsertable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn().getInsertable());
        basic.getColumn().setInsertable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getInsertable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedInsertable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedInsertable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getInsertable());
        ormColumn.setSpecifiedInsertable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedUnique() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setUnique(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getUnique());
        basic.getColumn().setUnique(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn().getUnique());
        basic.getColumn().setUnique(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUnique());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedUnique() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedUnique(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUnique());
        ormColumn.setSpecifiedUnique(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedLength() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setLength(Integer.valueOf(8));
        OrmColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)8, (Object)basic.getColumn().getLength());
        basic.getColumn().setLength(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn().getLength());
        basic.getColumn().setLength(Integer.valueOf(11));
        OrmColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)11, (Object)basic.getColumn().getLength());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedLength() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedLength(Integer.valueOf(7));
        OrmColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)7, (Object)basic.getColumn().getLength());
        ormColumn.setSpecifiedLength(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedPrecision() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setPrecision(Integer.valueOf(8));
        OrmColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)8, (Object)basic.getColumn().getPrecision());
        basic.getColumn().setPrecision(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn().getPrecision());
        basic.getColumn().setPrecision(Integer.valueOf(11));
        OrmColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)11, (Object)basic.getColumn().getPrecision());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedPrecision() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedPrecision(Integer.valueOf(7));
        OrmColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)7, (Object)basic.getColumn().getPrecision());
        ormColumn.setSpecifiedPrecision(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedScale() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn((XmlColumn)OrmFactory.eINSTANCE.createXmlColumnImpl());
        basic.getColumn().setScale(Integer.valueOf(8));
        OrmColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedScale());
        OrmColumnTests.assertEquals((Object)8, (Object)basic.getColumn().getScale());
        basic.getColumn().setScale(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn().getScale());
        basic.getColumn().setScale(Integer.valueOf(11));
        OrmColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedScale());
        OrmColumnTests.assertEquals((Object)11, (Object)basic.getColumn().getScale());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedScale() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedScale(Integer.valueOf(7));
        OrmColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedScale());
        OrmColumnTests.assertEquals((Object)7, (Object)basic.getColumn().getScale());
        ormColumn.setSpecifiedScale(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testVirtualColumnDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ListIterator attributes = ormPersistentType.virtualAttributes();
        attributes.next();
        OrmPersistentAttribute namePersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmBasicMapping nameVirtualMapping = (OrmBasicMapping)namePersistentAttribute.getMapping();
        OrmColumn ormColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"name", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_LENGTH, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_PRECISION, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_SCALE, (Object)ormColumn.getSpecifiedScale());
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("name").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("FOO");
        javaBasicMapping.getColumn().setSpecifiedTable("FOO_TABLE");
        javaBasicMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaBasicMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaBasicMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaBasicMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        javaBasicMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        javaBasicMapping.getColumn().setSpecifiedLength(Integer.valueOf(45));
        javaBasicMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaBasicMapping.getColumn().setSpecifiedScale(Integer.valueOf(47));
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"FOO_TABLE", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)45, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)46, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)47, (Object)ormColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmColumnTests.assertEquals((String)"name", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_LENGTH, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_PRECISION, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_SCALE, (Object)ormColumn.getSpecifiedScale());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmColumnTests.assertEquals((String)"name", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_LENGTH, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_PRECISION, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_SCALE, (Object)ormColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(null);
        OrmColumnTests.assertEquals((String)"name", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_LENGTH, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_PRECISION, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_SCALE, (Object)ormColumn.getSpecifiedScale());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"FOO_TABLE", (String)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)45, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)46, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)47, (Object)ormColumn.getSpecifiedScale());
    }

    public void testNullColumnDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute namePersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "name");
        OrmBasicMapping nameVirtualMapping = (OrmBasicMapping)namePersistentAttribute.getMapping();
        OrmColumn ormColumn = nameVirtualMapping.getColumn();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("name").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("FOO");
        javaBasicMapping.getColumn().setSpecifiedTable("FOO_TABLE");
        javaBasicMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaBasicMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaBasicMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaBasicMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        javaBasicMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        javaBasicMapping.getColumn().setSpecifiedLength(Integer.valueOf(45));
        javaBasicMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaBasicMapping.getColumn().setSpecifiedScale(Integer.valueOf(47));
        OrmColumnTests.assertEquals((String)"name", (String)ormColumn.getDefaultName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getDefaultUnique());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_LENGTH, (Object)ormColumn.getDefaultLength());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_PRECISION, (Object)ormColumn.getDefaultPrecision());
        OrmColumnTests.assertEquals((Object)Column.DEFAULT_SCALE, (Object)ormColumn.getDefaultScale());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualColumnTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ListIterator attributes = ormPersistentType.virtualAttributes();
        attributes.next();
        OrmPersistentAttribute namePersistentAttribute = (OrmPersistentAttribute)attributes.next();
        OrmBasicMapping nameVirtualMapping = (OrmBasicMapping)namePersistentAttribute.getMapping();
        OrmColumn ormColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getSpecifiedTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        OrmColumnTests.assertEquals((String)"ORM_TABLE", (String)ormColumn.getSpecifiedTable());
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("name").getMapping();
        javaBasicMapping.getColumn().setSpecifiedTable("JAVA_TABLE");
        OrmColumnTests.assertEquals((String)"JAVA_TABLE", (String)ormColumn.getSpecifiedTable());
        namePersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "name");
        nameVirtualMapping = (OrmBasicMapping)namePersistentAttribute.getMapping();
        ormColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmColumnTests.assertEquals((String)"ORM_TABLE", (String)ormColumn.getDefaultTable());
    }
}

