/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTable;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlTable;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraintImpl;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmTableTests
extends ContextModelTestCase {
    public OrmTableTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable ormTable = ormEntity.getTable();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedName());
        OrmTableTests.assertNull((Object)entityResource.getTable());
        entityResource.setTable(OrmFactory.eINSTANCE.createXmlTable());
        entityResource.getTable().setName("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormTable.getSpecifiedName());
        OrmTableTests.assertEquals((String)"FOO", (String)entityResource.getTable().getName());
        entityResource.getTable().setName(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedName());
        OrmTableTests.assertNull((Object)entityResource.getTable().getName());
        entityResource.getTable().setName("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormTable.getSpecifiedName());
        OrmTableTests.assertEquals((String)"FOO", (String)entityResource.getTable().getName());
        entityResource.setTable(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedName());
        OrmTableTests.assertNull((Object)entityResource.getTable());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmTable ormTable = ((OrmEntity)ormPersistentType.getMapping()).getTable();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedName());
        OrmTableTests.assertNull((Object)entityResource.getTable());
        ormTable.setSpecifiedName("foo");
        OrmTableTests.assertEquals((String)"foo", (String)ormTable.getSpecifiedName());
        OrmTableTests.assertEquals((String)"foo", (String)entityResource.getTable().getName());
        ormTable.setSpecifiedName(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedName());
        OrmTableTests.assertNull((Object)entityResource.getTable());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        ormEntity.getJavaEntity().getTable().setSpecifiedName("Foo");
        OrmTableTests.assertEquals((String)"Foo", (String)ormEntity.getTable().getDefaultName());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        ormEntity.setSpecifiedMetadataComplete(null);
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmTableTests.assertEquals((String)"Foo", (String)ormEntity.getTable().getDefaultName());
        ormEntity.getTable().setSpecifiedName("Bar");
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
    }

    public void testUpdateDefaultNameNoJava() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertEquals((String)"Foo", (String)ormEntity.getTable().getDefaultName());
    }

    public void testUpdateDefaultNameFromEntityName() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        ormEntity.setSpecifiedName("foo");
        OrmTableTests.assertEquals((String)"foo", (String)ormEntity.getTable().getDefaultName());
        ormEntity.setSpecifiedName(null);
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        ormEntity.getJavaEntity().setSpecifiedName("foo");
        OrmTableTests.assertEquals((String)"foo", (String)ormEntity.getTable().getDefaultName());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
    }

    public void testUpdateDefaultNameFromParent() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        OrmPersistentType parentOrmPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childOrmPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestTypeChild");
        OrmEntity parentXmlEntity = (OrmEntity)parentOrmPersistentType.getMapping();
        OrmEntity childXmlEntity = (OrmEntity)childOrmPersistentType.getMapping();
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)parentXmlEntity.getTable().getDefaultName());
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)childXmlEntity.getTable().getDefaultName());
        parentXmlEntity.getTable().setSpecifiedName("FOO");
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)parentXmlEntity.getTable().getDefaultName());
        OrmTableTests.assertEquals((String)"FOO", (String)childXmlEntity.getTable().getDefaultName());
        parentXmlEntity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmTableTests.assertEquals((String)"AnnotationTestType", (String)parentXmlEntity.getTable().getDefaultName());
        OrmTableTests.assertEquals((String)"AnnotationTestTypeChild", (String)childXmlEntity.getTable().getDefaultName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable ormTable = ormEntity.getTable();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedSchema());
        OrmTableTests.assertNull((Object)entityResource.getTable());
        entityResource.setTable(OrmFactory.eINSTANCE.createXmlTable());
        entityResource.getTable().setSchema("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormTable.getSpecifiedSchema());
        OrmTableTests.assertEquals((String)"FOO", (String)entityResource.getTable().getSchema());
        entityResource.getTable().setSchema(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedSchema());
        OrmTableTests.assertNull((Object)entityResource.getTable().getSchema());
        entityResource.getTable().setSchema("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormTable.getSpecifiedSchema());
        OrmTableTests.assertEquals((String)"FOO", (String)entityResource.getTable().getSchema());
        entityResource.setTable(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedSchema());
        OrmTableTests.assertNull((Object)entityResource.getTable());
    }

    public void testUpdateDefaultSchemaFromJavaTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
        ormEntity.getJavaEntity().getTable().setSpecifiedSchema("Foo");
        OrmTableTests.assertEquals((String)"Foo", (String)ormEntity.getTable().getDefaultSchema());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
        ormEntity.setSpecifiedMetadataComplete(null);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmTableTests.assertEquals((String)"Foo", (String)ormEntity.getTable().getDefaultSchema());
        ormEntity.getTable().setSpecifiedName("Bar");
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
    }

    public void testUpdateDefaultSchemaNoJava() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
    }

    public void testUpdateDefaultSchemaFromParent() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        OrmPersistentType parentOrmPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childOrmPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestTypeChild");
        OrmEntity parentXmlEntity = (OrmEntity)parentOrmPersistentType.getMapping();
        OrmEntity childXmlEntity = (OrmEntity)childOrmPersistentType.getMapping();
        OrmTableTests.assertNull((Object)parentXmlEntity.getTable().getDefaultSchema());
        OrmTableTests.assertNull((Object)childXmlEntity.getTable().getDefaultSchema());
        parentXmlEntity.getTable().setSpecifiedSchema("FOO");
        OrmTableTests.assertNull((Object)parentXmlEntity.getTable().getDefaultSchema());
        OrmTableTests.assertEquals((String)"FOO", (String)childXmlEntity.getTable().getDefaultSchema());
        parentXmlEntity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmTableTests.assertNull((Object)parentXmlEntity.getTable().getDefaultSchema());
        OrmTableTests.assertNull((Object)childXmlEntity.getTable().getDefaultSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormEntity.getTable().getDefaultSchema());
        this.entityMappings().setSpecifiedSchema("BAR");
        OrmTableTests.assertEquals((String)"BAR", (String)ormEntity.getTable().getDefaultSchema());
        ormEntity.getJavaEntity().getTable().setSpecifiedSchema("JAVA_SCHEMA");
        OrmTableTests.assertEquals((String)"JAVA_SCHEMA", (String)ormEntity.getTable().getDefaultSchema());
        ormEntity.getTable().setSpecifiedName("BLAH");
        OrmTableTests.assertEquals((String)"BAR", (String)ormEntity.getTable().getDefaultSchema());
        this.entityMappings().setSpecifiedSchema(null);
        OrmTableTests.assertEquals((String)"FOO", (String)ormEntity.getTable().getDefaultSchema());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema(null);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultSchema());
        ormEntity.getTable().setSpecifiedName(null);
        OrmTableTests.assertEquals((String)"JAVA_SCHEMA", (String)ormEntity.getTable().getDefaultSchema());
    }

    public void testModifySpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable ormTable = ormEntity.getTable();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedSchema());
        OrmTableTests.assertNull((Object)entityResource.getTable());
        ormTable.setSpecifiedSchema("foo");
        OrmTableTests.assertEquals((String)"foo", (String)ormTable.getSpecifiedSchema());
        OrmTableTests.assertEquals((String)"foo", (String)entityResource.getTable().getSchema());
        ormTable.setSpecifiedSchema(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedSchema());
        OrmTableTests.assertNull((Object)entityResource.getTable());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable ormTable = ormEntity.getTable();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertNull((Object)entityResource.getTable());
        entityResource.setTable(OrmFactory.eINSTANCE.createXmlTable());
        entityResource.getTable().setCatalog("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertEquals((String)"FOO", (String)entityResource.getTable().getCatalog());
        entityResource.getTable().setCatalog(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertNull((Object)entityResource.getTable().getCatalog());
        entityResource.getTable().setCatalog("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertEquals((String)"FOO", (String)entityResource.getTable().getCatalog());
        entityResource.setTable(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertNull((Object)entityResource.getTable());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable ormTable = ormEntity.getTable();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertNull((Object)entityResource.getTable());
        ormTable.setSpecifiedCatalog("foo");
        OrmTableTests.assertEquals((String)"foo", (String)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertEquals((String)"foo", (String)entityResource.getTable().getCatalog());
        ormTable.setSpecifiedCatalog(null);
        OrmTableTests.assertNull((Object)ormTable.getSpecifiedCatalog());
        OrmTableTests.assertNull((Object)entityResource.getTable());
    }

    public void testUpdateDefaultCatalogFromJavaTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
        ormEntity.getJavaEntity().getTable().setSpecifiedCatalog("Foo");
        OrmTableTests.assertEquals((String)"Foo", (String)ormEntity.getTable().getDefaultCatalog());
        ormEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        ormEntity.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
        ormEntity.setSpecifiedMetadataComplete(null);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmTableTests.assertEquals((String)"Foo", (String)ormEntity.getTable().getDefaultCatalog());
        ormEntity.getTable().setSpecifiedName("Bar");
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
    }

    public void testUpdateDefaultCatalogNoJava() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
    }

    public void testUpdateDefaultCatalogFromParent() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        OrmPersistentType parentOrmPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childOrmPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestTypeChild");
        OrmEntity parentXmlEntity = (OrmEntity)parentOrmPersistentType.getMapping();
        OrmEntity childXmlEntity = (OrmEntity)childOrmPersistentType.getMapping();
        OrmTableTests.assertNull((Object)parentXmlEntity.getTable().getDefaultCatalog());
        OrmTableTests.assertNull((Object)childXmlEntity.getTable().getDefaultCatalog());
        parentXmlEntity.getTable().setSpecifiedCatalog("FOO");
        OrmTableTests.assertNull((Object)parentXmlEntity.getTable().getDefaultCatalog());
        OrmTableTests.assertEquals((String)"FOO", (String)childXmlEntity.getTable().getDefaultCatalog());
        parentXmlEntity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmTableTests.assertNull((Object)parentXmlEntity.getTable().getDefaultCatalog());
        OrmTableTests.assertNull((Object)childXmlEntity.getTable().getDefaultCatalog());
    }

    public void testUpdateDefaultCatalogFromPersistenceUnitDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog("FOO");
        OrmTableTests.assertEquals((String)"FOO", (String)ormEntity.getTable().getDefaultCatalog());
        this.entityMappings().setSpecifiedCatalog("BAR");
        OrmTableTests.assertEquals((String)"BAR", (String)ormEntity.getTable().getDefaultCatalog());
        ormEntity.getJavaEntity().getTable().setSpecifiedCatalog("JAVA_CATALOG");
        OrmTableTests.assertEquals((String)"JAVA_CATALOG", (String)ormEntity.getTable().getDefaultCatalog());
        ormEntity.getTable().setSpecifiedName("BLAH");
        OrmTableTests.assertEquals((String)"BAR", (String)ormEntity.getTable().getDefaultCatalog());
        this.entityMappings().setSpecifiedCatalog(null);
        OrmTableTests.assertEquals((String)"FOO", (String)ormEntity.getTable().getDefaultCatalog());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog(null);
        OrmTableTests.assertNull((Object)ormEntity.getTable().getDefaultCatalog());
        ormEntity.getTable().setSpecifiedName(null);
        OrmTableTests.assertEquals((String)"JAVA_CATALOG", (String)ormEntity.getTable().getDefaultCatalog());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        ListIterator uniqueConstraints = ormEntity.getTable().uniqueConstraints();
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlTable tableResource = OrmFactory.eINSTANCE.createXmlTable();
        entityResource.setTable(tableResource);
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        tableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        tableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        uniqueConstraints = ormEntity.getTable().uniqueConstraints();
        OrmTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmTableTests.assertEquals((String)"bar", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"foo", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTableTests.assertEquals((int)0, (int)ormEntity.getTable().uniqueConstraintsSize());
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlTable tableResource = OrmFactory.eINSTANCE.createXmlTable();
        entityResource.setTable(tableResource);
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        tableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        tableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        OrmTableTests.assertEquals((int)2, (int)ormEntity.getTable().uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable table = ormEntity.getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(0).addColumnName(0, "BAR");
        table.addUniqueConstraint(0).addColumnName(0, "BAZ");
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlTable tableResource = entityResource.getTable();
        ListIterator uniqueConstraints = tableResource.getUniqueConstraints().listIterator();
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable table = ormEntity.getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(1).addColumnName(0, "BAR");
        table.addUniqueConstraint(0).addColumnName(0, "BAZ");
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlTable tableResource = entityResource.getTable();
        ListIterator uniqueConstraints = tableResource.getUniqueConstraints().listIterator();
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable table = ormEntity.getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(1).addColumnName(0, "BAR");
        table.addUniqueConstraint(2).addColumnName(0, "BAZ");
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlTable tableResource = entityResource.getTable();
        OrmTableTests.assertEquals((int)3, (int)tableResource.getUniqueConstraints().size());
        table.removeUniqueConstraint(1);
        ListIterator uniqueConstraintResources = tableResource.getUniqueConstraints().listIterator();
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        ListIterator uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        table.removeUniqueConstraint(1);
        uniqueConstraintResources = tableResource.getUniqueConstraints().listIterator();
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        table.removeUniqueConstraint(0);
        uniqueConstraintResources = tableResource.getUniqueConstraints().listIterator();
        OrmTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable table = ormEntity.getTable();
        table.addUniqueConstraint(0).addColumnName(0, "FOO");
        table.addUniqueConstraint(1).addColumnName(0, "BAR");
        table.addUniqueConstraint(2).addColumnName(0, "BAZ");
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlTable tableResource = entityResource.getTable();
        OrmTableTests.assertEquals((int)3, (int)tableResource.getUniqueConstraints().size());
        table.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintResources = tableResource.getUniqueConstraints().listIterator();
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        table.moveUniqueConstraint(0, 1);
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintResources = tableResource.getUniqueConstraints().listIterator();
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmTable table = ormEntity.getTable();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlTable tableResource = OrmFactory.eINSTANCE.createXmlTable();
        entityResource.setTable(tableResource);
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        tableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"FOO");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        tableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAR");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        tableResource.getUniqueConstraints().add(2, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAZ");
        ListIterator uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableResource.getUniqueConstraints().move(2, 0);
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableResource.getUniqueConstraints().move(0, 1);
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableResource.getUniqueConstraints().remove(0);
        uniqueConstraints = table.uniqueConstraints();
        OrmTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

