/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.persistence;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class RootContextNodeTests
extends ContextModelTestCase {
    public RootContextNodeTests(String name) {
        super(name);
    }

    public void testModifyAddPersistenceXml() throws Exception {
        PersistenceResource pr = this.persistenceResource();
        this.deleteResource((Resource)pr);
        RootContextNodeTests.assertFalse((boolean)pr.exists());
        JpaRootContextNode baseJpaContent = this.getJavaProject().getJpaProject().getRootContextNode();
        RootContextNodeTests.assertNull((Object)baseJpaContent.getPersistenceXml());
        baseJpaContent.addPersistenceXml();
        RootContextNodeTests.assertNotNull((Object)baseJpaContent.getPersistenceXml());
        boolean exceptionThrown = false;
        try {
            baseJpaContent.addPersistenceXml();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        RootContextNodeTests.assertTrue((boolean)exceptionThrown);
    }

    public void testModifyRemovePersistenceXml() throws Exception {
        JpaRootContextNode baseJpaContent = this.getJavaProject().getJpaProject().getRootContextNode();
        RootContextNodeTests.assertNotNull((Object)baseJpaContent.getPersistenceXml());
        baseJpaContent.removePersistenceXml();
        this.waitForWorkspaceJobs();
        RootContextNodeTests.assertNull((Object)baseJpaContent.getPersistenceXml());
        boolean exceptionThrown = false;
        try {
            baseJpaContent.removePersistenceXml();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        RootContextNodeTests.assertTrue((boolean)exceptionThrown);
    }

    public void testUpdateAddPersistenceXml() throws Exception {
        PersistenceResource pr = this.persistenceResource();
        this.deleteResource((Resource)pr);
        RootContextNodeTests.assertFalse((boolean)pr.exists());
        JpaRootContextNode baseJpaContent = this.getJavaProject().getJpaProject().getRootContextNode();
        RootContextNodeTests.assertNull((Object)baseJpaContent.getPersistenceXml());
        pr.getContents().add((Object)PersistenceFactory.eINSTANCE.createXmlPersistence());
        pr.save(null);
        RootContextNodeTests.assertNotNull((Object)baseJpaContent.getPersistenceXml());
    }

    public void testUpdateRemovePersistenceXml() throws Exception {
        PersistenceResource pr = this.persistenceResource();
        JpaRootContextNode baseJpaContent = this.getJavaProject().getJpaProject().getRootContextNode();
        RootContextNodeTests.assertNotNull((Object)baseJpaContent.getPersistenceXml());
        this.deleteResource((Resource)pr);
        RootContextNodeTests.assertNull((Object)baseJpaContent.getPersistenceXml());
    }
}

