/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.core.internal.resource.orm.OrmResourceModelProvider;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;

public class OrmModelTests
extends TestCase {
    static final String BASE_PROJECT_NAME = OrmModelTests.class.getSimpleName();
    TestJpaProject jpaProject;

    public OrmModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jpaProject = TestJpaProject.buildJpaProject(BASE_PROJECT_NAME, false);
    }

    protected void createFile() throws CoreException {
        OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        modelProvider.createResource();
    }

    protected void tearDown() throws Exception {
        this.jpaProject.getProject().delete(true, true, null);
        this.jpaProject = null;
        super.tearDown();
    }

    public void testModelLoad() {
        OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        OrmModelTests.assertNotNull((Object)modelProvider);
        OrmResource resource = (OrmResource)modelProvider.getResource();
        OrmModelTests.assertNotNull((Object)resource);
    }

    public void testModelLoad2() {
        OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        OrmModelTests.assertNotNull((Object)modelProvider);
        OrmResource resource = (OrmResource)modelProvider.getResource();
        OrmModelTests.assertNotNull((Object)resource);
    }

    public void testModelLoadForDifferentlyNamedOrmXml() {
        OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getModelProvider((IProject)this.jpaProject.getProject(), (String)"META-INF/orm2.xml");
        OrmModelTests.assertNotNull((Object)modelProvider);
        OrmResource resource = (OrmResource)modelProvider.getResource();
        OrmModelTests.assertNotNull((Object)resource);
    }

    public void testCreateFile() throws CoreException {
        this.createFile();
        OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getDefaultModelProvider((IProject)this.jpaProject.getProject());
        OrmModelTests.assertNotNull((Object)modelProvider);
        OrmResource resource = (OrmResource)modelProvider.getResource();
        OrmModelTests.assertNotNull((Object)resource);
        OrmModelTests.assertTrue((boolean)resource.exists());
    }
}

