/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class BasicTests
extends JavaResourceModelTestCase {
    public BasicTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestBasic() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Basic"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
            }
        });
    }

    private ICompilationUnit createTestBasicWithOptional() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Basic"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(optional=true)");
            }
        });
    }

    private ICompilationUnit createTestBasicWithFetch() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Basic", "javax.persistence.FetchType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(fetch=FetchType.EAGER)");
            }
        });
    }

    public void testBasic() throws Exception {
        ICompilationUnit cu = this.createTestBasic();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        BasicTests.assertNotNull((Object)basic);
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        BasicTests.assertTrue((boolean)basic.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        BasicTests.assertTrue((boolean)basic.getOptional());
        basic.setOptional(Boolean.valueOf(false));
        BasicTests.assertFalse((boolean)basic.getOptional());
        this.assertSourceContains("@Basic(optional=false)", cu);
    }

    public void testSetOptionalNull() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        BasicTests.assertTrue((boolean)basic.getOptional());
        basic.setOptional(null);
        BasicTests.assertNull((Object)basic.getOptional());
        this.assertSourceContains("@Basic", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)FetchType.EAGER, (Object)basic.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)FetchType.EAGER, (Object)basic.getFetch());
        basic.setFetch(FetchType.LAZY);
        BasicTests.assertEquals((Object)FetchType.LAZY, (Object)basic.getFetch());
        this.assertSourceContains("@Basic(fetch=LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)FetchType.EAGER, (Object)basic.getFetch());
        basic.setFetch(null);
        BasicTests.assertNull((Object)basic.getFetch());
        this.assertSourceContains("@Basic", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }
}

