/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.internal.GenericJpaProject;
import org.eclipse.jpt.core.internal.SimpleJpaProjectConfig;
import org.eclipse.jpt.core.internal.resource.java.JpaCompilationUnitImpl;
import org.eclipse.jpt.core.internal.utility.jdt.NullAnnotationEditFormatter;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;

public class JavaResourceModelTestCase
extends AnnotationTestCase {
    private JavaElementChangeListener javaElementChangeListener;
    protected JpaCompilationUnit jpaCompilationUnit;

    public JavaResourceModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaElementChangeListener = new JavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.javaElementChangeListener = null;
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.jpaCompilationUnit != null) {
            this.jpaCompilationUnit.javaElementChanged(event);
        }
    }

    protected ICompilationUnit createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        return this.createAnnotationAndMembers("javax.persistence", annotationName, annotationBody);
    }

    protected ICompilationUnit createAnnotationAndMembers(String packageName, String annotationName, String annotationBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    protected ICompilationUnit createEnumAndMembers(String enumName, String enumBody) throws Exception {
        return this.createEnumAndMembers("javax.persistence", enumName, enumBody);
    }

    protected ICompilationUnit createEnumAndMembers(String packageName, String enumName, String enumBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    protected JpaProject buildJpaProject() throws CoreException {
        return new TestJpaProject(this.buildJpaProjectConfig(this.javaProject.getProject()));
    }

    protected JpaProject.Config buildJpaProjectConfig(IProject project) {
        SimpleJpaProjectConfig config = new SimpleJpaProjectConfig();
        config.setProject(project);
        config.setJpaPlatform(JptCorePlugin.getJpaPlatform((IProject)project));
        config.setConnectionProfileName(JptCorePlugin.getConnectionProfileName((IProject)project));
        config.setDiscoverAnnotatedClasses(JptCorePlugin.discoverAnnotatedClasses((IProject)project));
        return config;
    }

    protected JavaResourcePersistentType buildJavaTypeResource(ICompilationUnit cu) throws CoreException {
        this.jpaCompilationUnit = this.buildJpaCompilationUnit(cu);
        this.jpaCompilationUnit.resolveTypes();
        return this.hackJavaResourcePersistentType();
    }

    protected JavaResourcePersistentType hackJavaResourcePersistentType() {
        return (JavaResourcePersistentType)ClassTools.fieldValue((Object)this.jpaCompilationUnit, (String)"persistentType");
    }

    protected JpaCompilationUnit buildJpaCompilationUnit(ICompilationUnit cu) throws CoreException {
        if (this.jpaCompilationUnit != null) {
            throw new IllegalStateException();
        }
        JpaProject jpaProject = this.buildJpaProject();
        return new JpaCompilationUnitImpl(cu, jpaProject.getJpaPlatform().getAnnotationProvider(), CommandExecutorProvider.Default.instance(), NullAnnotationEditFormatter.instance(), this.buildResourceModelListener());
    }

    ResourceModelListener buildResourceModelListener() {
        return new ResourceModelListener(){

            public void resourceModelChanged() {
            }
        };
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JavaResourceModelTestCase.this.javaElementChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected class TestJpaProject
    extends GenericJpaProject {
        protected TestJpaProject(JpaProject.Config config) throws CoreException {
            super(config);
            this.setUpdater(JpaProject.Updater.Null.instance());
            this.addJar(org.eclipse.jpt.core.tests.internal.projects.TestJpaProject.jpaJarName());
        }

        protected void addJar(String jarPath) throws JavaModelException {
            this.addClasspathEntry(JavaCore.newLibraryEntry((IPath)new Path(jarPath), null, null));
        }

        private void addClasspathEntry(IClasspathEntry entry) throws JavaModelException {
            this.getJavaProject().setRawClasspath((IClasspathEntry[])CollectionTools.add((Object[])this.getJavaProject().getRawClasspath(), (Object)entry), null);
        }

        protected IResourceProxyVisitor buildInitialResourceProxyVisitor() {
            return new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    return false;
                }
            };
        }

        protected JpaRootContextNode buildRootContextNode() {
            return null;
        }
    }
}

