/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.MappingFile;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.AbstractJpaContextNode;
import org.eclipse.jpt.core.internal.resource.persistence.PersistenceResourceModelProvider;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRootContextNode
extends AbstractJpaContextNode
implements JpaRootContextNode {
    protected final JpaProject jpaProject;
    protected PersistenceXml persistenceXml;

    public GenericRootContextNode(JpaProject jpaProject) {
        super(null);
        if (jpaProject == null) {
            throw new IllegalArgumentException("The JPA project must not be null");
        }
        this.jpaProject = jpaProject;
        PersistenceResourceModelProvider modelProvider = PersistenceResourceModelProvider.getDefaultModelProvider(jpaProject.getProject());
        PersistenceResource resource = (PersistenceResource)((Object)modelProvider.getResource());
        if (resource.exists()) {
            this.persistenceXml = this.buildPersistenceXml(resource);
        }
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jpaProject.getProject();
    }

    @Override
    public JpaContextNode getParent() {
        return null;
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return null;
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return null;
    }

    @Override
    public PersistenceXml getPersistenceXml() {
        return this.persistenceXml;
    }

    protected void setPersistenceXml(PersistenceXml persistenceXml) {
        PersistenceXml old = this.persistenceXml;
        this.persistenceXml = persistenceXml;
        this.firePropertyChanged("persistenceXml", old, persistenceXml);
    }

    @Override
    public PersistenceXml addPersistenceXml() {
        if (this.persistenceXml != null) {
            throw new IllegalStateException();
        }
        PersistenceResourceModelProvider modelProvider = PersistenceResourceModelProvider.getDefaultModelProvider(this.getProject());
        PersistenceResource resource = (PersistenceResource)((Object)modelProvider.getResource());
        modelProvider.modify(new Runnable(){

            public void run() {
            }
        });
        PersistenceXml px = this.buildPersistenceXml(resource);
        this.setPersistenceXml(px);
        return px;
    }

    @Override
    public void removePersistenceXml() {
        if (this.persistenceXml == null) {
            throw new IllegalStateException();
        }
        this.persistenceXml.dispose();
        PersistenceResourceModelProvider modelProvider = PersistenceResourceModelProvider.getDefaultModelProvider(this.jpaProject.getProject());
        PersistenceResource resource = (PersistenceResource)((Object)modelProvider.getResource());
        try {
            WorkbenchResourceHelper.deleteResource((Resource)resource);
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
        if (!resource.exists()) {
            this.setPersistenceXml(null);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        PersistenceResourceModelProvider modelProvider = PersistenceResourceModelProvider.getDefaultModelProvider(this.jpaProject.getProject());
        PersistenceResource resource = (PersistenceResource)((Object)modelProvider.getResource());
        if (resource.exists()) {
            if (this.persistenceXml != null) {
                this.persistenceXml.update(resource);
            } else {
                this.setPersistenceXml(this.buildPersistenceXml(resource));
            }
        } else {
            this.setPersistenceXml(null);
        }
    }

    protected PersistenceXml buildPersistenceXml(PersistenceResource persistenceResource) {
        return this.getJpaFactory().buildPersistenceXml(this, persistenceResource);
    }

    @Override
    public void validate(List<IMessage> messages) {
        if (this.persistenceXml == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PROJECT_NO_PERSISTENCE_XML", this));
            return;
        }
        if (!this.jpaProject.discoversAnnotatedClasses()) {
            this.validateOrphanClasses(messages);
        }
        this.persistenceXml.validate(messages);
    }

    protected void validateOrphanClasses(List<IMessage> messages) {
        Persistence persistence = this.persistenceXml.getPersistence();
        if (persistence == null) {
            return;
        }
        if (persistence.persistenceUnitsSize() != 1) {
            return;
        }
        PersistenceUnit persistenceUnit = persistence.persistenceUnits().next();
        HashBag orphans = CollectionTools.bag(this.jpaProject.annotatedClassNames());
        for (String javaTypeName : CollectionTools.iterable(this.jpaProject.annotatedClassNames())) {
            for (ClassRef classRef : CollectionTools.iterable(persistenceUnit.specifiedClassRefs())) {
                if (!classRef.isFor(javaTypeName)) continue;
                orphans.remove((Object)javaTypeName);
            }
            for (MappingFileRef mappingFileRef : CollectionTools.iterable(persistenceUnit.mappingFileRefs())) {
                MappingFile mappingFile = mappingFileRef.getMappingFile();
                if (mappingFile == null || mappingFile.getPersistentType(javaTypeName) == null) continue;
                orphans.remove((Object)javaTypeName);
            }
        }
        for (String orphan : orphans) {
            JavaResourcePersistentType jrpt = this.jpaProject.getJavaResourcePersistentType(orphan);
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CONTEXT", new String[]{persistenceUnit.getName()}, jrpt.getJpaCompilationUnit().getCompilationUnit().getResource(), jrpt.getMappingAnnotation().getTextRange(JDTTools.buildASTRoot(jrpt.getJpaCompilationUnit().getCompilationUnit()))));
        }
    }
}

