/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaTemporalConverter;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericJavaTemporalConverter
extends AbstractJavaJpaContextNode
implements JavaTemporalConverter {
    private TemporalType temporalType;
    private JavaResourcePersistentAttribute resourcePersistentAttribute;

    public GenericJavaTemporalConverter(JavaAttributeMapping parent, JavaResourcePersistentAttribute jrpa) {
        super(parent);
        this.initialize(jrpa);
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    public String getType() {
        return "temporalConverter";
    }

    protected String getAnnotationName() {
        return "javax.persistence.Temporal";
    }

    public void addToResourceModel() {
        this.resourcePersistentAttribute.addSupportingAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistentAttribute.removeSupportingAnnotation(this.getAnnotationName());
    }

    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    public void setTemporalType(TemporalType newTemporalType) {
        TemporalType oldTemporalType = this.temporalType;
        this.temporalType = newTemporalType;
        this.getResourceTemporal().setValue(TemporalType.toJavaResourceModel(newTemporalType));
        this.firePropertyChanged("temporalTypeProperty", (Object)oldTemporalType, (Object)newTemporalType);
    }

    protected void setTemporalType_(TemporalType newTemporalType) {
        TemporalType oldTemporalType = this.temporalType;
        this.temporalType = newTemporalType;
        this.firePropertyChanged("temporalTypeProperty", (Object)oldTemporalType, (Object)newTemporalType);
    }

    protected TemporalAnnotation getResourceTemporal() {
        return (TemporalAnnotation)this.resourcePersistentAttribute.getSupportingAnnotation(this.getAnnotationName());
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.temporalType = this.temporalType(this.getResourceTemporal());
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.setTemporalType_(this.temporalType(this.getResourceTemporal()));
    }

    protected TemporalType temporalType(TemporalAnnotation resourceTemporal) {
        return resourceTemporal == null ? null : TemporalType.fromJavaResourceModel(resourceTemporal.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceTemporal().getTextRange(astRoot);
    }
}

