/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlSingleRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmSingleRelationshipMapping<T extends XmlSingleRelationshipMapping>
extends AbstractOrmRelationshipMapping<T>
implements OrmSingleRelationshipMapping {
    protected final List<OrmJoinColumn> specifiedJoinColumns = new ArrayList<OrmJoinColumn>();
    protected OrmJoinColumn defaultJoinColumn;
    protected Boolean specifiedOptional;

    protected AbstractOrmSingleRelationshipMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        OrmJoinColumn oldDefaultJoinColumn = this.defaultJoinColumn;
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        XmlJoinColumnImpl resourceJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        OrmJoinColumn contextJoinColumn = this.buildJoinColumn(resourceJoinColumn);
        this.specifiedJoinColumns.add(index, contextJoinColumn);
        ((XmlSingleRelationshipMapping)this.resourceAttributeMapping).getJoinColumns().add(index, (Object)resourceJoinColumn);
        this.fireItemAdded("specifiedJoinColumnsList", index, contextJoinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return contextJoinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    protected void addSpecifiedJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (this.specifiedJoinColumns.isEmpty()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
        ((XmlSingleRelationshipMapping)this.resourceAttributeMapping).getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedJoinColumnsList", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlSingleRelationshipMapping)this.resourceAttributeMapping).getJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterator<OrmJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public Boolean getOptional() {
        return this.specifiedOptional != null ? this.specifiedOptional : this.getDefaultOptional();
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean optional) {
        Boolean old = this.specifiedOptional;
        this.specifiedOptional = optional;
        ((XmlSingleRelationshipMapping)this.resourceAttributeMapping).setOptional(optional);
        this.firePropertyChanged("specifiedOptionalProperty", old, optional);
    }

    protected void setSpecifiedOptional_(Boolean optional) {
        Boolean old = this.specifiedOptional;
        this.specifiedOptional = optional;
        this.firePropertyChanged("specifiedOptionalProperty", old, optional);
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    @Override
    public void initialize(XmlAttributeMapping attributeMapping) {
        super.initialize(attributeMapping);
        this.specifiedOptional = ((XmlSingleRelationshipMapping)this.resourceAttributeMapping).getOptional();
        this.initializeSpecifiedJoinColumns();
        this.initializeDefaultJoinColumn();
    }

    protected void initializeSpecifiedJoinColumns() {
        if (this.resourceAttributeMapping != null) {
            for (XmlJoinColumn resourceJoinColumn : ((XmlSingleRelationshipMapping)this.resourceAttributeMapping).getJoinColumns()) {
                this.specifiedJoinColumns.add(this.buildJoinColumn(resourceJoinColumn));
            }
        }
    }

    protected void initializeDefaultJoinColumn() {
        if (this.shouldBuildDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns() && this.isRelationshipOwner();
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.getJpaFactory().buildOrmJoinColumn(this, new JoinColumnOwner(), resourceJoinColumn);
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedOptional_(((XmlSingleRelationshipMapping)this.resourceAttributeMapping).getOptional());
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    protected void updateSpecifiedJoinColumns() {
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedJoinColumns();
        CloneListIterator resourceJoinColumns = new CloneListIterator(((XmlSingleRelationshipMapping)this.resourceAttributeMapping).getJoinColumns());
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn contextJoinColumn = contextJoinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                contextJoinColumn.update((XmlJoinColumn)resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(contextJoinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn((XmlJoinColumn)resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn() {
        if (this.shouldBuildDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update(null);
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    @Override
    protected String defaultTargetEntity(JavaResourcePersistentAttribute persistentAttributeResource) {
        if (persistentAttributeResource.typeIsContainer()) {
            return null;
        }
        return persistentAttributeResource.getQualifiedReferenceEntityTypeName();
    }

    @Override
    public void initializeFromOrmSingleRelationshipMapping(OrmSingleRelationshipMapping oldMapping) {
        super.initializeFromOrmSingleRelationshipMapping(oldMapping);
        int index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable(oldMapping.specifiedJoinColumns())) {
            OrmJoinColumn newJoinColumn = this.addSpecifiedJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
    }

    @Override
    public FetchType getDefaultFetch() {
        return DEFAULT_FETCH_TYPE;
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.connectionProfileIsActive()) {
            this.validateJoinColumns(messages);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages) {
        if (this.ownerIsEntity() && this.isRelationshipOwner()) {
            ListIterator<OrmJoinColumn> stream = this.joinColumns();
            while (stream.hasNext()) {
                this.validateJoinColumn((OrmJoinColumn)stream.next(), messages);
            }
        }
    }

    protected void validateJoinColumn(OrmJoinColumn joinColumn, List<IMessage> messages) {
        String tableName = joinColumn.getTable();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), tableName, joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{tableName, joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange()));
            }
            return;
        }
        if (!joinColumn.isResolved()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange()));
            }
        }
        if (!joinColumn.isReferencedColumnResolved()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange()));
            }
        }
    }

    public class JoinColumnOwner
    implements OrmJoinColumn.Owner {
        public String getDefaultTableName() {
            return AbstractOrmSingleRelationshipMapping.this.getTypeMapping().getPrimaryTableName();
        }

        public Entity getTargetEntity() {
            return AbstractOrmSingleRelationshipMapping.this.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return AbstractOrmSingleRelationshipMapping.this.getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return AbstractOrmSingleRelationshipMapping.this;
        }

        public boolean tableNameIsInvalid(String tableName) {
            return AbstractOrmSingleRelationshipMapping.this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return AbstractOrmSingleRelationshipMapping.this.getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractOrmSingleRelationshipMapping.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return AbstractOrmSingleRelationshipMapping.this.joinColumnsSize();
        }

        public TextRange getValidationTextRange() {
            return AbstractOrmSingleRelationshipMapping.this.getValidationTextRange();
        }
    }
}

