/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmPersistentAttribute
extends AbstractXmlContextNode
implements OrmPersistentAttribute {
    protected OrmAttributeMapping attributeMapping;

    public GenericOrmPersistentAttribute(OrmPersistentType parent, String mappingKey) {
        super(parent);
        this.attributeMapping = this.buildAttributeMapping(mappingKey);
    }

    protected OrmAttributeMapping buildAttributeMapping(String key) {
        return this.getJpaPlatform().buildOrmAttributeMappingFromMappingKey(key, this);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.persistentAttribute";
    }

    @Override
    public String getName() {
        return this.attributeMapping.getName();
    }

    @Override
    public void nameChanged(String oldName, String newName) {
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public OrmAttributeMapping getSpecifiedMapping() {
        return this.attributeMapping;
    }

    @Override
    public OrmAttributeMapping getMapping() {
        return this.attributeMapping;
    }

    @Override
    public String getMappingKey() {
        return this.attributeMapping.getKey();
    }

    @Override
    public String getDefaultMappingKey() {
        return null;
    }

    @Override
    public void setSpecifiedMappingKey(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmAttributeMapping oldMapping = this.attributeMapping;
        this.attributeMapping = this.buildAttributeMapping(newMappingKey);
        this.getPersistentType().changeMapping(this, oldMapping, this.attributeMapping);
        this.firePropertyChanged("specifiedMappingProperty", oldMapping, this.attributeMapping);
    }

    protected void setSpecifiedMappingKey_(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmAttributeMapping oldMapping = this.attributeMapping;
        this.attributeMapping = this.buildAttributeMapping(newMappingKey);
        this.firePropertyChanged("specifiedMappingProperty", oldMapping, this.attributeMapping);
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return (OrmPersistentType)this.getParent();
    }

    @Override
    public OrmTypeMapping getTypeMapping() {
        return this.getPersistentType().getMapping();
    }

    @Override
    public boolean isVirtual() {
        return this.getPersistentType().containsVirtualPersistentAttribute(this);
    }

    @Override
    public void makeVirtual() {
        if (this.isVirtual()) {
            throw new IllegalStateException("Attribute is already virtual");
        }
        this.getPersistentType().makePersistentAttributeVirtual(this);
    }

    @Override
    public void makeSpecified() {
        if (!this.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        if (this.getMappingKey() == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            throw new IllegalStateException("Use makeSpecified(String) instead and specify a mapping type");
        }
        this.getPersistentType().makePersistentAttributeSpecified(this);
    }

    @Override
    public void makeSpecified(String mappingKey) {
        if (!this.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        this.getPersistentType().makePersistentAttributeSpecified(this, mappingKey);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.attributeMapping.getPrimaryKeyColumnName();
    }

    @Override
    public boolean isOverridableAttribute() {
        return this.attributeMapping.isOverridableAttributeMapping();
    }

    @Override
    public boolean isOverridableAssociation() {
        return this.attributeMapping.isOverridableAssociationMapping();
    }

    @Override
    public boolean isIdAttribute() {
        return this.attributeMapping.isIdMapping();
    }

    @Override
    public void initialize(XmlAttributeMapping attributeMapping) {
        this.attributeMapping.initialize(attributeMapping);
    }

    @Override
    public void update() {
        this.attributeMapping.update();
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        if (this.isVirtual()) {
            return false;
        }
        return this.attributeMapping.contains(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        if (this.isVirtual()) {
            return null;
        }
        return this.attributeMapping.getSelectionTextRange();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.attributeMapping.validate(messages);
    }

    @Override
    public TextRange getValidationTextRange() {
        if (this.isVirtual()) {
            return this.getPersistentType().getMapping().getAttributesTextRange();
        }
        return this.attributeMapping.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }

    @Override
    public void dispose() {
    }
}

