/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerAnnotationTools {
    public static NestableAnnotation addNestedAnnotation(int index, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        int size = containerAnnotation.nestedAnnotationsSize();
        NestableAnnotation nestedAnnotation = containerAnnotation.addInternal(size);
        nestedAnnotation.newAnnotation();
        containerAnnotation.moveInternal(index, size);
        ContainerAnnotationTools.synchAnnotationsAfterMove(index, size, containerAnnotation);
        return nestedAnnotation;
    }

    public static void synchAnnotationsAfterAdd(int index, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        ArrayList nestableAnnotations = CollectionTools.list(containerAnnotation.nestedAnnotations());
        int i = nestableAnnotations.size();
        while (i-- > index) {
            ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
        }
    }

    public static void synchAnnotationsAfterRemove(int index, ContainerAnnotation<? extends NestableAnnotation> pluralAnnotation) {
        ArrayList nestableAnnotations = CollectionTools.list(pluralAnnotation.nestedAnnotations());
        int i = index;
        while (i < nestableAnnotations.size()) {
            ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
            ++i;
        }
    }

    private static void synch(NestableAnnotation nestableAnnotation, int index) {
        nestableAnnotation.moveAnnotation(index);
    }

    public static void synchAnnotationsAfterMove(int targetIndex, int sourceIndex, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        NestableAnnotation nestableAnnotation = containerAnnotation.nestedAnnotationAt(targetIndex);
        ContainerAnnotationTools.synch(nestableAnnotation, containerAnnotation.nestedAnnotationsSize());
        ArrayList nestableAnnotations = CollectionTools.list(containerAnnotation.nestedAnnotations());
        if (sourceIndex < targetIndex) {
            int i = sourceIndex;
            while (i < targetIndex) {
                ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
                ++i;
            }
        } else {
            int i = sourceIndex;
            while (i > targetIndex) {
                ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
                --i;
            }
        }
        ContainerAnnotationTools.synch(nestableAnnotation, targetIndex);
    }

    public static void initializeNestedAnnotations(CompilationUnit astRoot, ContainerAnnotation<?> containerAnnotation) {
        ContainerAnnotationTools.addAnnotationsFromSource(astRoot, containerAnnotation);
    }

    private static void addAnnotationsFromSource(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        containerAnnotation.getJdtAnnotation(astRoot).accept(ContainerAnnotationTools.buildInitialAnnotationVisitor(astRoot, containerAnnotation));
    }

    private static ASTVisitor buildInitialAnnotationVisitor(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        return new InitialAnnotationVisitor(astRoot, containerAnnotation);
    }

    public static void updateNestedAnnotationsFromJava(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        ContainerAnnotationTools.addOrUpdateAnnotationInSource(astRoot, containerAnnotation);
        ContainerAnnotationTools.removeAnnotationsNotInSource(astRoot, containerAnnotation);
    }

    private static void addOrUpdateAnnotationInSource(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        containerAnnotation.getJdtAnnotation(astRoot).accept(ContainerAnnotationTools.buildUpdateAnnotationVisitor(astRoot, containerAnnotation));
    }

    private static void removeAnnotationsNotInSource(CompilationUnit astRoot, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        for (NestableAnnotation annotation : CollectionTools.iterable(containerAnnotation.nestedAnnotations())) {
            if (annotation.getJdtAnnotation(astRoot) != null) continue;
            containerAnnotation.remove(annotation);
        }
    }

    private static ASTVisitor buildUpdateAnnotationVisitor(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        return new UpdateAnnotationVisitor(astRoot, containerAnnotation);
    }

    private ContainerAnnotationTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AnnotationVisitor
    extends ASTVisitor {
        protected final CompilationUnit astRoot;
        protected final ContainerAnnotation<? extends NestableAnnotation> containerAnnotation;

        AnnotationVisitor(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
            this.astRoot = astRoot;
            this.containerAnnotation = containerAnnotation;
        }

        public boolean visit(MemberValuePair node) {
            return node.getName().getFullyQualifiedName().equals(this.containerAnnotation.getElementName());
        }

        public boolean visit(SingleMemberAnnotation node) {
            return this.visit_((Annotation)node);
        }

        public boolean visit(NormalAnnotation node) {
            return this.visit_((Annotation)node);
        }

        public boolean visit(MarkerAnnotation node) {
            return this.visit_((Annotation)node);
        }

        protected boolean visit_(Annotation node) {
            String jdtAnnotationName = JDTTools.resolveAnnotation(node);
            if (this.containerAnnotation.getAnnotationName().equals(jdtAnnotationName)) {
                return true;
            }
            if (this.containerAnnotation.getNestableAnnotationName().equals(jdtAnnotationName)) {
                this.visitNestedAnnotation(node);
            }
            return false;
        }

        protected abstract void visitNestedAnnotation(Annotation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitialAnnotationVisitor
    extends AnnotationVisitor {
        InitialAnnotationVisitor(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
            super(astRoot, containerAnnotation);
        }

        @Override
        protected void visitNestedAnnotation(Annotation node) {
            Object nestedAnnotation = this.containerAnnotation.addInternal(this.containerAnnotation.nestedAnnotationsSize());
            nestedAnnotation.initialize(this.astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateAnnotationVisitor
    extends AnnotationVisitor {
        UpdateAnnotationVisitor(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
            super(astRoot, containerAnnotation);
        }

        @Override
        protected void visitNestedAnnotation(Annotation node) {
            Object nestedAnnotation = this.containerAnnotation.nestedAnnotationFor(node);
            if (nestedAnnotation == null) {
                nestedAnnotation = this.containerAnnotation.add(this.containerAnnotation.nestedAnnotationsSize());
                nestedAnnotation.initialize(this.astRoot);
            } else {
                nestedAnnotation.update(this.astRoot);
            }
        }
    }
}

